% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks.R
\name{log_shiny_input_changes}
\alias{log_shiny_input_changes}
\title{Auto logging input changes in Shiny app}
\usage{
log_shiny_input_changes(input, level = INFO)
}
\arguments{
\item{input}{passed from Shiny's \code{server}}

\item{level}{log level}
}
\description{
This is to be called in the \code{server} section of the Shiny app.
}
\examples{
\dontrun{
library(shiny)

ui <- bootstrapPage(
    numericInput('mean', 'mean', 0),
    numericInput('sd', 'sd', 1),
    textInput('title', 'title', 'title'),
    textInput('foo', 'This is not used at all, still gets logged', 'foo'),
    plotOutput('plot')
)

server <- function(input, output) {

    logger::log_shiny_input_changes(input)

    output$plot <- renderPlot({
        hist(rnorm(1e3, input$mean, input$sd), main = input$title)
    })

}

shinyApp(ui = ui, server = server)
}
}
