% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlay_plot.R
\name{overlay_plot}
\alias{overlay_plot}
\title{Plot overlaying eQTL and GWAS data}
\usage{
overlay_plot(
  loc,
  base_col = "black",
  alpha = 0.5,
  scheme = "RdYlBu",
  tissue = "Whole Blood",
  eqtl_gene = loc$gene,
  legend_pos = "topright",
  ...
)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \code{\link[=locus]{locus()}}.}

\item{base_col}{Colour of points for SNPs which do not have eQTLs.}

\item{alpha}{Alpha opacity for non-eQTL points}

\item{scheme}{Character string specifying palette for effect size showing
up/downregulation eQTL using \link[grDevices:palettes]{grDevices::hcl.colors}. Alternatively a
vector of 6 colours.}

\item{tissue}{GTex tissue in which eQTL has been measured}

\item{eqtl_gene}{Gene showing eQTL effect}

\item{legend_pos}{Character value specifying legend position. See \code{\link[=legend]{legend()}}.}

\item{...}{Other arguments passed to \code{\link[=locus_plot]{locus_plot()}} for the locus plot.}
}
\value{
No return value. Produces a plot using base graphics.
}
\description{
Experimental plotting function for overlaying eQTL data from GTEx on top of
GWAS results. y axis shows the -log10 p-value for the GWAS result.
Significant eQTL for the specified gene are overlaid using colours and
symbols.
}
