% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMK_outliers.R
\name{LMK_plotVar}
\alias{LMK_plotVar}
\title{Plot Variance}
\usage{
LMK_plotVar(a, lmknames = NULL, tabonly = FALSE, ...)
}
\arguments{
\item{a}{an array, presumably already aligned}

\item{lmknames}{A vector of landmark names to plot. If null (default) points are labeled by index.}

\item{tabonly}{Logical. If FALSE (default) function returns list of mean variance by landmark and plots values. If TURE, plotting steps are suppressed.}

\item{...}{Additional arguments to pass to plotting functions}
}
\value{
Returns a list of mean variance by landmark for the entire dataset. Also produces a plot with mean variance (green) and 1 SD (dark green)
}
\description{
Function to plot variance within landmarks for a dataset
}
\examples{

require(geomorph)
data(plethodon)
gpa <- gpagen(plethodon$land)
LMK_plotVar(gpa$coords) ## most landmarks show low variance
## lmks 11,12 plot above 1 standard deviation 


}
