% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_lme4.R, R/bootstrap_nlme.R,
%   R/generics.R
\name{resid_bootstrap.lmerMod}
\alias{resid_bootstrap.lmerMod}
\alias{resid_bootstrap.lme}
\alias{resid_bootstrap}
\title{Residual Bootstrap for Nested LMEs}
\usage{
\method{resid_bootstrap}{lmerMod}(model, fn, B)

\method{resid_bootstrap}{lme}(model, fn, B)

resid_bootstrap(model, fn, B)
}
\arguments{
\item{model}{The model object you wish to bootstrap.}

\item{fn}{A function returning the statistic(s) of interest.}

\item{B}{The number of bootstrap resamples.}
}
\value{
The returned value is an object of class "boot", compatible with the \pkg{boot}
package's \code{\link[boot]{boot}} methods.
}
\description{
Generate residual bootstrap replicates of a statistic for a nested linear 
mixed-effects model.
}
\details{
The residual bootstrap resamples the residual quantities from the fitted 
linear mixed-effects model in order to generate bootstrap resamples. That is, 
a random sample, drawn with replacement, is taken from the estimated error terms 
and the EBLUPS (at each level) and the random samples are combined into bootstrap
samples via the fitted model equation.
}
\references{
Van der Leeden, R., Meijer, E. and Busing F. M. (2008) Resampling multilevel 
   models. In J. de Leeuw and E. Meijer, editors, \emph{Handbook of 
   Multilevel Analysis}, pages 401--433. New York: Springer.
}
\seealso{
\itemize{
  \item \code{\link{parametric_bootstrap}}, \code{\link{resid_bootstrap}},
     \code{\link{case_bootstrap}}, \code{\link{cgr_bootstrap}}, 
     \code{\link{reb_bootstrap}} for more details on a specific bootstrap.
  \item \code{\link[lme4]{bootMer}} in the \pkg{lme4} package for an 
     implementation of (semi-)parameteric bootstrap for mixed models.
  \item \code{\link[boot]{boot}}, \code{\link[boot]{boot.ci}}, and \code{\link[boot]{plot.boot}} 
     from the \pkg{boot} package.
}
}
