% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl.memq.R
\name{qtl.memq}
\alias{qtl.memq}
\title{Performs Multi-Environment (or Multi-Trait)
Multi-QTL analysis for balanced populations.}
\usage{
qtl.memq (crossobj = crossobj, P.data = NULL, env.label = NULL,
               trait, step, method, threshold, distance,
               cofactors, window.size = 50)
}
\arguments{
\item{crossobj}{An object of class = cross obtained from the qtl.cross
function from this package, or the read.cross function from r/qtl package
(Broman and Sen, 2009).This file contains phenotypic means, genotypic
marker score, and genetic map data.}

\item{P.data}{The name of the file containing the phenotypic information
in a long format.}

\item{env.label}{vector with the names of the environment (or traits)
to select for the QTL analysis.}

\item{trait}{name for the phenotypic trait to be analyzed.}

\item{step}{Maximum distance (in cM) between positions at which the genotype
probabilities are calculated, though for step = 0, probabilities are
calculated only at the marker locations.}

\item{method}{'SIM' or 'CIM' for simple interval (SIM) or
composite interval mapping (CIM).}

\item{threshold}{options are: Li&Ji (Li and Ji, 2005),
FDR (Benjamini and Hochberg, 1995), and set alpha levels (p.values).}

\item{distance}{To avoid co-linearity, nearby markers are not allowed
in the same model. This is the minimum distance within which two markers
are allowed to stay in the model.}

\item{cofactors}{Vector of genetic predictors to be used as cofactors}

\item{window.size}{To avoid co-linearity, marker cofactors close to the
markers being tested are not allowed in the model. This is the minimum
distance to allow a co-factor when testing for a specific marker. Given the
resolution of common QTL studies, it is recommended to use a large
window.size (i.e. 50 cM). The default is set to 50 cM.}
}
\value{
The function returns a data.frame with the final QTL indicating
the locus names, chromosome, position, p.values tested and QTL effects
that are printed to qtl_memq_reports.
}
\description{
Mixed models have been used in balanced populations to detect
QTL-by-environment (QEI) effects while modeling the variance-covariance
matrix. This function performs a multi-environment (or multi-trait)
multi-QTL biparental analysis modeling the correlations across
environments (traits).
}
\details{
'SIM' or 'CIM' could be perform.
}
\note{
For single trait and single environment see qtl.analysis
}
\examples{
 \dontrun{
data (SxM_geno)
data (SxM_map)
data (SxMxE_pheno)

P.data <- SxMxE_pheno
G.data <- SxM_geno
map.data <- SxM_map

cross.data <- qtl.cross (P.data, G.data, map.data, cross='dh',
                         heterozygotes=FALSE)

summary (cross.data)

## Pheno Quality
## pq.diagnostics (crossobj=cross.data, boxplot =FALSE)

## Marker Quality
mq.diagnostics (crossobj=cross.data,I.threshold=0.1,
             p.val=0.01,na.cutoff=0.1)

# QTL_SIM
QTL.result <- qtl.memq (crossobj = cross.data, P.data = P.data,
                        env.label = c('ID91','ID92','MAN92','MTd91',
                        'MTd92','MTi91','MTi92','SKs92','WA91','WA92'),
                        trait = 'yield', step = 10, method = 'SIM',
                        threshold = 'Li&Ji', distance = 50, cofactors = NULL,
                        window.size = 50)

## QTL_CIM
QTL.result <- qtl.memq (crossobj = cross.data, P.data = P.data,
                       env.label = c('ID91','ID92','MAN92','MTd91','MTd92',
                       'MTi91','MTi92','SKs92','WA91','WA92'),
                       trait = 'yield', step = 10, method = 'CIM',
                       threshold = 'Li&Ji', distance = 50,
                       cofactors = QTL.result$selected$marker, window.size = 50)
}
}
\author{
Lucia Gutierrez
}
\references{
Hayes PM, Liu BH, Knapp SJ, Chen F, Jones B, Blake T,
            Franckowiak JD, Rasmusson DC, Sorrells M, Ullrich SE,
            Wesenberg DM, Kleinhofs A (1993) Quantitative trait locus
            effects and environmental interaction in a sample of North
            American barley germplasm. Theor Appl Genet 87:392-401.
            Malosetti, M., C.G. van der Linden, B. Vosman, and
            F. a van Eeuwijk. 2007a. A mixed-model approach to association
            mapping using pedigree information with an illustration of
            resistance to Phytophthora infestans in potato.
            Genetics 175(2): 879-89.
            Malosetti, M., J.M. Ribaut, M. Vargas, J. Crossa, and
            F. a. Eeuwijk. 2007b. A multi-trait multi-environment QTL
            mixed model with an application to drought and nitrogen stress
            trials in maize (Zea mays L.). Euphytica 161(1-2): 241-257.
}
\seealso{
qtl.analysis
}

