### $Id: Weights.q,v 1.1 1998/04/10 23:02:02 bates Exp $
### Strength over time for subjects in three different weight-training
### programs.  Data set 3.2(a) from "SAS System for Mixed Models"
"Weights" <-
  structure(list(
strength = c(85, 85, 86, 85, 87, 86, 87, 80, 79, 
  79, 78, 78, 79, 78, 78, 77, 77, 77, 76, 76, 77, 84, 84, 85, 84, 
  83, 84, 85, 80, 81, 80, 80, 79, 79, 80, 76, 78, 77, 78, 78, 77, 
  74, 79, 79, 80, 79, 80, 79, 81, 76, 76, 76, 75, 75, 74, 74, 77, 
  78, 78, 80, 80, 81, 80, 79, 79, 79, 79, 77, 78, 79, 81, 81, 80, 
  80, 80, 81, 82, 77, 76, 77, 78, 77, 77, 77, 82, 83, 83, 83, 84, 
  83, 83, 84, 84, 83, 82, 81, 79, 78, 79, 81, 81, 82, 82, 82, 80, 
  79, 79, 78, 77, 77, 78, 78, 83, 82, 83, 85, 84, 83, 82, 78, 78, 
  79, 79, 78, 77, 77, 80, 80, 79, 79, 80, 80, 80, 78, 79, 80, 81, 
  80, 79, 80, 79, 79, 79, 80, 80, 78, 80, 83, 83, 85, 85, 86, 87, 
  87, 81, 83, 82, 82, 83, 83, 82, 81, 81, 81, 82, 82, 83, 81, 80, 
  81, 82, 82, 82, 84, 86, 76, 76, 76, 76, 76, 76, 75, 81, 84, 83, 
  83, 85, 85, 85, 77, 78, 79, 79, 81, 82, 81, 84, 85, 87, 89, 88, 
  85, 86, 74, 75, 78, 78, 79, 78, 78, 76, 77, 77, 77, 77, 76, 76, 
  84, 84, 86, 85, 86, 86, 86, 79, 80, 79, 80, 80, 82, 82, 78, 78, 
  77, 76, 75, 75, 76, 78, 80, 77, 77, 75, 75, 75, 84, 85, 85, 85, 
  85, 83, 82, 84, 85, 84, 83, 83, 83, 84, 74, 75, 75, 76, 75, 76, 
  76, 83, 84, 82, 81, 83, 83, 82, 86, 87, 87, 87, 87, 87, 86, 82, 
  83, 84, 85, 84, 85, 86, 79, 80, 79, 79, 80, 79, 80, 79, 79, 79, 
  81, 81, 83, 83, 87, 89, 91, 90, 91, 92, 92, 81, 81, 81, 82, 82, 
  83, 83, 82, 82, 82, 84, 86, 85, 87, 79, 79, 80, 81, 81, 81, 81, 
  79, 80, 81, 82, 83, 82, 82, 83, 84, 84, 84, 84, 83, 83, 81, 81, 
  82, 84, 83, 82, 85, 78, 78, 79, 79, 78, 79, 79, 83, 82, 82, 84, 
  84, 83, 84, 80, 79, 79, 81, 80, 80, 80, 80, 82, 82, 82, 81, 81, 
  81, 85, 86, 87, 86, 86, 86, 86, 77, 78, 80, 81, 82, 82, 82, 80, 
  81, 80, 81, 81, 82, 83),
Subject = structure(factor(c(1, 1, 1, 
  1, 1, 1, 1, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15, 15, 
  15, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 18, 
  18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 
  20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 2, 2, 2, 2, 2, 2, 
  2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 
  5, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 
  8, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 
  11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 1, 1, 1, 1, 1, 1, 
  1, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15, 15, 15, 16, 
  16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 
  18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 
  20, 20, 21, 21, 21, 21, 21, 21, 21, 2, 2, 2, 2, 2, 2, 2, 3, 3, 
  3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 6, 6, 
  6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 1, 1, 
  1, 1, 1, 1, 1, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15, 
  15, 15, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 
  18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 20, 20, 
  20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 2, 2, 2, 2, 2, 
  2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 
  5, 5, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 
  8, 8, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 11, 11, 
  11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 
  14, 14, 14), levels=1:21), class = "factor",
  .Label = c("1", 
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "2", 
    "20", "21", "3", "4", "5", "6", "7", "8", "9")),
Program = structure(factor(c(1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3),
  levels=1:3), class = "factor", .Label = c("CONT", "RI", "WI")),
Subj = structure(ordered(c(20, 20, 20, 20, 20, 
  20, 20, 8, 8, 8, 8, 8, 8, 8, 2, 2, 2, 2, 2, 2, 2, 19, 19, 19, 
  19, 19, 19, 19, 13, 13, 13, 13, 13, 13, 13, 3, 3, 3, 3, 3, 3, 
  3, 11, 11, 11, 11, 11, 11, 11, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 
  9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 14, 14, 14, 14, 14, 14, 14, 
  4, 4, 4, 4, 4, 4, 4, 17, 17, 17, 17, 17, 17, 17, 16, 16, 16, 
  16, 16, 16, 16, 15, 15, 15, 15, 15, 15, 15, 5, 5, 5, 5, 5, 5, 
  5, 18, 18, 18, 18, 18, 18, 18, 6, 6, 6, 6, 6, 6, 6, 12, 12, 12, 
  12, 12, 12, 12, 10, 10, 10, 10, 10, 10, 10, 26, 26, 26, 26, 26, 
  26, 26, 34, 34, 34, 34, 34, 34, 34, 30, 30, 30, 30, 30, 30, 30, 
  29, 29, 29, 29, 29, 29, 29, 31, 31, 31, 31, 31, 31, 31, 21, 21, 
  21, 21, 21, 21, 21, 32, 32, 32, 32, 32, 32, 32, 27, 27, 27, 27, 
  27, 27, 27, 36, 36, 36, 36, 36, 36, 36, 25, 25, 25, 25, 25, 25, 
  25, 23, 23, 23, 23, 23, 23, 23, 35, 35, 35, 35, 35, 35, 35, 28, 
  28, 28, 28, 28, 28, 28, 22, 22, 22, 22, 22, 22, 22, 24, 24, 24, 
  24, 24, 24, 24, 33, 33, 33, 33, 33, 33, 33, 52, 52, 52, 52, 52, 
  52, 52, 37, 37, 37, 37, 37, 37, 37, 49, 49, 49, 49, 49, 49, 49, 
  56, 56, 56, 56, 56, 56, 56, 54, 54, 54, 54, 54, 54, 54, 39, 39, 
  39, 39, 39, 39, 39, 43, 43, 43, 43, 43, 43, 43, 57, 57, 57, 57, 
  57, 57, 57, 47, 47, 47, 47, 47, 47, 47, 53, 53, 53, 53, 53, 53, 
  53, 41, 41, 41, 41, 41, 41, 41, 45, 45, 45, 45, 45, 45, 45, 51, 
  51, 51, 51, 51, 51, 51, 48, 48, 48, 48, 48, 48, 48, 38, 38, 38, 
  38, 38, 38, 38, 50, 50, 50, 50, 50, 50, 50, 40, 40, 40, 40, 40, 
  40, 40, 46, 46, 46, 46, 46, 46, 46, 55, 55, 55, 55, 55, 55, 55, 
  42, 42, 42, 42, 42, 42, 42, 44, 44, 44, 44, 44, 44, 44), levels=1:57),
  class = c("ordered", "factor"),
  .Label = c("CONT/8", "CONT/3", "CONT/6", 
    "CONT/12", "CONT/16", "CONT/18", "CONT/10", "CONT/2", "CONT/9", 
    "CONT/20", "CONT/7", "CONT/19", "CONT/5", "CONT/11", "CONT/15", 
    "CONT/14", "CONT/13", "CONT/17", "CONT/4", "CONT/1", "RI/6", 
    "RI/14", "RI/11", "RI/15", "RI/10", "RI/1", "RI/8", "RI/13", 
    "RI/4", "RI/3", "RI/5", "RI/7", "RI/16", "RI/2", "RI/12", "RI/9", 
    "WI/2", "WI/15", "WI/6", "WI/17", "WI/11", "WI/20", "WI/7", "WI/21", 
    "WI/12", "WI/18", "WI/9", "WI/14", "WI/3", "WI/16", "WI/13", 
    "WI/1", "WI/10", "WI/5", "WI/19", "WI/4", "WI/8")),
Time = c(1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 
  13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 
  9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 
  5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 
  1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 
  11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 
  7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 
  3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 
  13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 
  9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 
  5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 
  1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 
  11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 
  7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 
  3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 
  13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 
  9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 
  5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 
  1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 
  11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 
  7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 3, 5, 7, 9, 11, 13, 1, 
  3, 5, 7, 9, 11, 13)),
FUN = function (x) mean(x, na.rm = TRUE),
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = strength ~ Time | Subj,
order.groups = TRUE,
outer = ~Program,
row.names = 1:399,
labels = list(x = "Time since beginning of study", y = "Strength"),
units = list(x = "(days)"))
