\name{vgam.crc}
\alias{vgam.crc}
\title{Build a VGAM CRC model}
\usage{
vgam.crc(dat, models = make.hierarchical.term.sets(k = attributes(dt)$k), sdf,
  llform = NULL, round.vars = NULL, rounding.scale = NULL,
  boot.control = NULL)
}
\arguments{
  \item{dat}{The CRC data, as output of \code{format.data}}

  \item{models}{A list of models -- or an expression that
  returns a list of models -- to be considered in local
  model search.  Run the default,
  \code{\link{make.hierarchical.term.sets}(k =
  attributes(dat)$k)}, to see an example.}

  \item{sdf}{A vector, with length corresponding to the
  number of continuous predictor variables, that states the
  desired effective degrees of freedom for the
  corresponding smooth spline in VGAM.}

  \item{llform}{A character vector of predictors of the
  form "c1", "c2" for main effects, or "c12" for an
  interaction.  By default, the function \code{AICc.vgam}
  is used to select the best set of terms among the
  candidate sets that are proposed by the function
  \code{\link{make.hierarchical.term.sets}}.}

  \item{round.vars}{See \code{\link{micro.post.stratify}},
  which is called within \code{vgam.crc}.}

  \item{rounding.scale}{See
  \code{\link{micro.post.stratify}}, which is called within
  \code{vgam.crc}.}

  \item{boot.control}{A list of control parameters for
  bootstrapping the sampling distribution of the
  estimator(s).  By default, there is no bootstrapping.}
}
\value{
\item{est}{A point estimate of the population size}
\item{llform}{The set of log-linear terms} \item{dat}{The
output of function \code{micro.post.stratify}, with
estimated local rates of missingness appended as an extra
column labeled \code{pi0}.  In addition, \code{mct}
(multinomial cell count) gives the number of observed units
with that distinct covariate vector, and \code{cpi0}
(cumulative number missing) gives the the product of
\code{pi0} with \code{mct}, such that summing over this
vectorized product is exactly the Horvitz-Thompson style
sum in capture recapture. } \item{aic}{The AICc for the
chosen VGAM, as computed by function \code{AICc.vgam}}
\item{mod}{The VGAM model object; see the \code{vgam}
function in package \code{VGAM} for details} \item{...}{The
output is of class \code{vgam.crc} and has attributes
\code{cont.x} and \code{conteg.x}, which relate the
continuous and categorical variables in the model }
}
\description{
A high-level function to fit a VGAM CRC model to
standardized data (the output of format.data).
}
\details{
Implements, approximately, the method of Zwane (2004).
Serves mainly as a user-friendly interface to the VGAM
package.
}
\author{
Zach Kurtz
}
\references{
Zwane E and Heijden Pvd (2003). "Implementing the
parametric bootstrap in capture-recapture models with
continuous covariates." \emph{Statistics & Probability
Letters}, \bold{65}, pp. 121-125.

Zwane E and Heijden Pvd (2004). "Semiparametric models for
capture-recapture studies with covariates."
\emph{Computational Statistics & Data Analysis}, \bold{47},
pp. 729-743.
}

