% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_perimp.R
\name{local_permutation_importance}
\alias{local_permutation_importance}
\title{Local permutation variable importance}
\usage{
local_permutation_importance(explained_instance, data, explained_var,
  model, top_n = nrow(data))
}
\arguments{
\item{explained_instance}{Data frame with one observation for which
prediction will be explained}

\item{data}{Data from with the same columns as explained_instance}

\item{explained_var}{Character with the names of response variable}

\item{model}{Model to be explained}

\item{top_n}{Number of observation that will be used to calculate 
local variable importance}
}
\value{
list of class "local_permutation_importance" that consists of
\item{residuals}{Data frame with names of variables in the dataset ("label") and
values of drop-out loss ("dropout_loss")}
\item{weighted_local_mse}{Value of weighted MSE for the whole dataset with weights
given by 1 - Gower distance from the explained instance}
\item{explained_instance}{Explained instance as a data frame}
}
\description{
This function calculates local variable importance (variable drop-out)
by finding top_n observations closest to the explained instance,
performing permutation variable importance and using weighted mean square
error as loss function with weights equal to 1 - Gower distances of the
closest observations to the explainedi instance.
}
\examples{
\dontrun{
local_permutation_importance(wine[5, ], wine, 
                             randomForest(quality~., data = wine),
                             top_n = 1000)
}

}
