% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidSVM.R
\name{selectSVMs}
\alias{select}
\alias{selectSVMs}
\title{Selects the best hyper-parameters of all the trained SVMs.}
\usage{
selectSVMs(model, command.args = NULL, ..., d = NULL,
  warn.suboptimal = getOption("liquidSVM.warn.suboptimal", TRUE))
}
\arguments{
\item{model}{the \code{svm}-model}

\item{command.args}{further arguments aranged in a list, corresponding to the arguments
of the command line interface to \code{svm-select}, e.g. \code{list(d=2,R=0)}
is equivalent to \code{svm-select -d 2 -R 0}.
See \link{command-args} for details.}

\item{...}{parameters passed to selection phase e.g. \code{retrain_method="select_on_entire_train_set"}}

\item{d}{level of display information}

\item{warn.suboptimal}{if TRUE this will issue a warning
if the boundary of the hyper-parameter grid was hit too many times.
The default can be changed by setting \code{options(liquidSVM.warn.suboptimal=FALSE)}.}
}
\value{
a table giving training and validation errors and more internal statistic
for all the SVMs that were selected.
This is also recorded in \code{model$select_errors}.
}
\description{
\strong{Should only be used by experts!}
This selects for every task and cell the best hyper-parameter based on the
validation errors in the folds. This is saved and will afterwards be used
in the evaluation of the decision functions.
}
\details{
Some learning scenarios have to perform several selection runs:
for instance in quantile regression for every quantile.
This is done by specifying \code{weight_number} ranging from 1 to the number of quantiles.

See \link{command-args} for details.
}
\section{Documentation for command-line parameters of svm-select}{

The following parameters can be used as well \itemize{
\ifelse{latex}{\out{\medskip}}{\cr}
\item \code{h=[<level>]}\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Displays all help messages.\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Meaning of specific values:\cr
<level> = 0  =>  short help messages\cr
<level> = 1  =>  detailed help messages\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Allowed values:\cr
<level>: 0 or 1\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Default values:\cr
<level> = 0\cr
\ifelse{latex}{\out{\medskip}}{\cr}
\ifelse{latex}{\out{\medskip}}{\cr}
\item \code{N=c(<class>,<constraint>)}\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Replaces the best validation error in the search for the best hyper-parameter\cr
combination by an NPL criterion, in which the best detection rate is searched\cr
for given the false alarm constraint <constraint> on class <class>.\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Allowed values:\cr
<class>: -1 or 1\cr
<constraint>: float between 0.0 and 1.0\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Default values:\cr
Option is deactivated.\cr
\ifelse{latex}{\out{\medskip}}{\cr}
\ifelse{latex}{\out{\medskip}}{\cr}
\item \code{R=<method>}\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Selects the method that produces decision functions from the different folds.\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Meaning of specific values:\cr
<method> = 0  =>   select for best average validation error\cr
<method> = 1  =>   on each fold select for best validation error\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Allowed values:\cr
<method>: integer between 0 and 1\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Default values:\cr
<method> = 1\cr
\ifelse{latex}{\out{\medskip}}{\cr}
\ifelse{latex}{\out{\medskip}}{\cr}
\item \code{W=<number>}\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Restrict the search for the best hyper-parameters to weights with the number\cr
<number>.\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Meaning of specific values:\cr
<number> = 0  =>   all weights are considered.\cr
\ifelse{latex}{\out{\medskip}}{\cr}
Default values:\cr
<number> = 0\cr
\ifelse{latex}{\out{\medskip}}{\cr}
\ifelse{latex}{\out{\medskip}}{\cr}
}
}
\seealso{
\link{command-args}, \code{\link{svm}}, \code{\link{init.liquidSVM}}, \code{\link{selectSVMs}}, \code{\link{predict.liquidSVM}}, \code{\link{test.liquidSVM}} and \code{\link{clean.liquidSVM}}
}

