% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{getSolution}
\alias{getSolution}
\title{Retrieve the solution of an SVM}
\usage{
getSolution(model, task = 1, cell = 1, fold = 1)
}
\arguments{
\item{model}{the model}

\item{task}{the task between 1 and number of tasks}

\item{cell}{the cell between 1 and number of cells}

\item{fold}{the fold between 1 and number of folds}
}
\value{
a list with three entries: the offset of the solution (not yet implemented),
the indices of the support vectors in the training data set, and
the coefficients of the support vectors
}
\description{
Gives the solution of an SVM that has been trained and selected
in an ad-hoc list.
}
\details{
liquidSVM splits all problems into tasks (e.g. for multiclass classification
or if using multiple weights), then each task is split into cells (maybe only a global one),
and every cell then is trained in one or more folds to yiele a solution.
Hence these coordinates have to be specified.
}
\note{
This is not tested thoroughly so use in production is at your own risk.
}
\examples{
\dontrun{
# simple example: regression of sinus curve
x <- seq(0,1,by=.01)
y <- sin(x*10)
a <- lapply(1:5, function(i)getSolution(model <- lsSVM(x,y,d=1), 1,1,i))
plot(x,y,type='l',ylim=c(-5,5));
for(i in 1:5) lines(coeff~samples, data=a[[i]],col=i)

# a more typical example
banana <- liquidData('banana-mc')
model <- mcSVM(Y~.,banana$train,d=1)
# task 4 is predicting 2 vs 3, there is only cell 1 here
solution <- getSolution(model,task=4,cell=1,fold=1)
supportvecs <- solution$samples
# we are considering task 4 and hence only show labels 2 and 3:
bananaSub <- banana$train[banana$train$Y \%in\% c(2,3),]
plot(bananaSub[,-1],col=bananaSub$Y)
points(supportvecs,pch='x',cex=2)
}
}

