% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library_call_linter.R
\name{library_call_linter}
\alias{library_call_linter}
\title{Library call linter}
\usage{
library_call_linter(allow_preamble = TRUE)
}
\arguments{
\item{allow_preamble}{Logical, default \code{TRUE}. If \code{FALSE},
no code is allowed to precede the first \code{library()} call,
otherwise some setup code is allowed, but all \code{library()}
calls must follow consecutively after the first one.}
}
\description{
Force library calls to all be at the top of the script.
}
\examples{
# will produce lints
lint(
  text = "
    library(dplyr)
    print('test')
    library(tidyr)
  ",
  linters = library_call_linter()
)

lint(
  text = "
    library(dplyr)
    print('test')
    library(tidyr)
    library(purrr)
  ",
  linters = library_call_linter()
)

# okay
lint(
  text = "
    library(dplyr)
    print('test')
  ",
  linters = library_call_linter()
)

lint(
  text = "
    # comment
    library(dplyr)
  ",
  linters = library_call_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
