% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkspotterGraphOnMatrix.R
\name{linkspotterGraphOnMatrix}
\alias{linkspotterGraphOnMatrix}
\title{Linspotter graph on matrix}
\usage{
linkspotterGraphOnMatrix(corMatrix, cluster = FALSE,
  variablesClustering = NULL, minCor = 0.3, corMethod = "Coef.",
  smoothEdges = T, dynamicNodes = F, colorEdgesByCorDirection = F)
}
\arguments{
\item{corMatrix}{a dataframe corresponding to a matrix of correlation or distance.}

\item{cluster}{a boolean to decide if to cluster variables or an integer corresponding directly to the number of clusters to consider. If variablesClustering is filled, "cluster" parameter is ignored.}

\item{variablesClustering}{a specific dataframe containing the output of the variable clustering resulting from the function clusterVariables()}

\item{minCor}{a double between 0 and 1. It is the minimal correlation absolute value to consider for the first graph plot.}

\item{corMethod}{a string. One of "pearson","spearman","kendall","mic", "distCor" or "MaxNMI". It is the correlation coefficient to consider for the first graph plot.}

\item{smoothEdges}{a boolean. TRUE to let the edges be smooth.}

\item{dynamicNodes}{a boolean. TRUE to let the graph re-organize itself after any movement.}

\item{colorEdgesByCorDirection}{a boolean. TRUE to get the edges colored according to the correlation direction (positive-> blue, negative->red or NA->grey).}
}
\value{
a visNetwork object corresponding to a dynamic graph for the correlation matrix visualization.
}
\description{
Run the linkSpotter graph on a correlation matrix.
}
\examples{
# calculate a correlation dataframe
data(iris)
corDF=multiBivariateCorrelation(dataset = iris)
corMatrix=corCouplesToMatrix(x1_x2_val = corDF[,c('X1','X2',"pearson")])
# launch the graph
linkspotterGraphOnMatrix(corMatrix=corMatrix, minCor=0.3)

}
