% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.feature.R
\name{map.feature}
\alias{map.feature}
\title{Create a map}
\usage{
map.feature(languages, features = "none", popup = "",
  stroke.features = NULL, latitude = NULL, longitude = NULL,
  color = NULL, stroke.color = NULL, title = NULL, control = TRUE,
  legend = TRUE, radius = 5, stroke.radius = 9.5, opacity = 1,
  stroke.opacity = 1, ...)
}
\arguments{
\item{languages}{character vector of linguoids (can be written in lower case)}

\item{features}{character vector of features}

\item{popup}{character vector of strings that will appear in pop-up window}

\item{stroke.features}{additional independent stroke features}

\item{latitude}{numeric vector of latitudes}

\item{longitude}{numeric vector of longitudes}

\item{color}{vector of colors}

\item{stroke.color}{vector of stroke colors}

\item{title}{of a legend}

\item{control}{logical. If FALSE, function doesn't show layer control buttons.}

\item{legend}{logical. If FALSE, function doesn't show legend.}

\item{radius}{a numeric vector of radii for the circles.}

\item{stroke.radius}{a numeric vector of stroke radii for the circles.}

\item{opacity}{a numeric vector of marker opacity.}

\item{stroke.opacity}{a numeric vector of stroke opacity.}

\item{...}{further arguments of leaflet package.}
}
\description{
Map a set of linguoids and color them by feature
}
\details{
Takes any vector of linguoids and return a map.
}
\examples{
map.feature(c("Adyghe", "Russian"))

## Map all Slavic languages
map.feature(lang.aff(c("Slavic")))

## Color linguoids by feature
df <- data.frame(lang = c("Adyghe", "Kabardian", "Polish", "Russian", "Bulgarian"),
feature = c("polysynthetic", "polysynthetic", "fusion", "fusion", "fusion"))
map.feature(df$lang, df$feature)

## Adding pop-up
df <- data.frame(lang = c("Adyghe", "Kabardian", "Polish", "Russian", "Bulgarian"),
feature = c("polysynthetic", "polysynthetic", "fusion", "fusion", "fusion"),
popup = c("Adyghe", "Adyghe", "Slavic", "Slavic", "Slavic"))
map.feature(df$lang, df$feature, df$popup)

## Adding title
df <- data.frame(lang = c("Adyghe", "Kabardian", "Polish", "Russian", "Bulgarian"),
feature = c("polysynthetic", "polysynthetic", "fusion", "fusion", "fusion"),
popup = c("Adyghe", "Adyghe", "Slavic", "Slavic", "Slavic"))
map.feature(df$lang, df$feature, df$popup, title = "type of a language")

## Add your own coordinates
map.feature("Adyghe", latitude = 43, longitude = 57)

## Add you own colors
df <- data.frame(lang = c("Adyghe", "Kabardian", "Polish", "Russian", "Bulgarian"),
feature = c("polysynthetic", "polysynthetic", "fusion", "fusion", "fusion"),
popup = c("Adyghe", "Adyghe", "Slavic", "Slavic", "Slavic"))
map.feature(df$lang, df$feature, df$popup, color = c("green", "navy"))

## Remove control buttons
map.feature(lang.aff("Sign"), control = FALSE)

}
\author{
George Moroz <agricolamz@gmail.com>
}

