% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulldiag.R
\name{pulldiag}
\alias{pulldiag}
\title{Pull out the diagonal from a distance matrix}
\usage{
pulldiag(d)
}
\arguments{
\item{d}{A distance matrix calculated by \code{\link{distee}}.}
}
\value{
A vector with the self-self distances.
}
\description{
Pull out the diagonal from a distance matrix calculated by
\code{\link{distee}} (that is, self-self distances).
}
\details{
We use the row and column names to identify which entries are self-self.
}
\examples{
data(expr1, expr2)

\dontshow{expr1 <- expr1[,1:500]
expr2 <- expr2[,1:500]}

# distance as RMS difference
d <- distee(expr1, expr2)

# pull out the self-self distances
d_selfself <- pulldiag(d)

# samples with smallest self-self correlation
sort(d_selfself)[1:10]

}
\seealso{
\code{\link{omitdiag}}, \code{\link{distee}}, \code{\link{disteg}},
\code{\link{summary.lineupdist}}, \code{\link{plot2dist}},
\code{\link{plot.lineupdist}}
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\keyword{array}
