\name{locus.likes.peaks} 
\alias{locus.likes.peaks} 
\title{likeLTD::locus.likes.peaks} 
\usage{locus.likes.peaks(hypothesis,results,\dots)}
\arguments{
  \item{hypothesis}{The hypothesis generated by either \code{prosecution.hypothesis.peaks} 
  or \code{defence.hypothesis.peaks}.}
  \item{results}{Either prosecution or defence results from \code{evaluate.peaks}
  e.g. \code{results$Pros} or \code{results$Def}.}
  \item{\dots}{Any extra parameter that was passed to \code{evaluate.peaks}.}
}
\value{Vector.} 
\description{Vector with individual locus likelihoods for peak height data.}
\details{
  Convert the overall likelihood returned by \code{evaluate.peaks} into locus specific likelihoods.
}
\seealso{evaluate.peaks}
\examples{
\dontrun{
# datapath to example files
datapath = file.path(system.file("extdata", package="likeLTD"),"laboratory")

# File paths and case name for allele report
admin = pack.admin.input.peaks(
            peaksFile = file.path(datapath, 'laboratory-CSP.csv'),
            refFile = file.path(datapath, 'laboratory-reference.csv'),
            caseName = "Laboratory",
            detectionThresh = 20
             )

# Enter arguments
args = list(
        nUnknowns = 1
        )

# Create hypotheses
hypP = do.call(prosecution.hypothesis.peaks, append(admin,args))
hypD = do.call(defence.hypothesis.peaks, append(admin,args))

# Get parameters for optimisation
paramsP = optimisation.params.peaks(hypP)
paramsD = optimisation.params.peaks(hypD)

# reduce number of iterations for demonstration purposes
paramsP$control$itermax=25
paramsD$control$itermax=25

# Run optimisation
# n.steps and converge set for demonstration purposes
results = evaluate.peaks(paramsP, paramsD, n.steps=1, 
      converge=FALSE)

# get locus likelihoods under prosecution
locus.likes.peaks(hypP,results$Pros)

# get locus LRs
locus.likes.peaks(hypP,results$Pros)/locus.likes.peaks(hypD,results$Def)
}
}
