% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board.R
\name{random_board}
\alias{random_board}
\title{Create a random (but solvable) Lights Out board}
\usage{
random_board(size, classic = TRUE)
}
\arguments{
\item{size}{Number of rows and columns for the board}

\item{classic}{If \code{TRUE}, then pressing a light will toggle it and its
adjacent neighbours only. If \code{FALSE}, then pressing a light will toggle
the entire row and column of the pressed light.}
}
\value{
A \code{lightsout} board object.
}
\description{
Create a Lights Out board that can be played by the user or solved automatically.
Only square boards of size 3x3, 5x5, 7x7, or 9x9 are supported. The initial
lights configuration is randomly generated, but always solvable. To create a
board with a user-defined configuration, use the \code{\link[lightsout]{new_board}} function.
}
\examples{
set.seed(10)

# Create a random 5x5 classic board
board <- random_board(5)
board

# Get the solution for the board
solution <- solve_board(board)
solution

# Press the lights according to the solution, the result should be a board
# with all lights switched off
play(board, matrix = solution)
}
\seealso{
\code{\link[lightsout]{new_board}}
\code{\link[lightsout]{play}}
\code{\link[lightsout]{solve_board}}
}
