% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spec.R
\name{lr_get_spec}
\alias{lr_get_spec}
\title{Extract spectral data from spectra files}
\usage{
lr_get_spec(
  where = getwd(),
  ext = "txt",
  lim = c(300, 700),
  decimal = ".",
  sep = NULL,
  subdir = FALSE,
  subdir.names = FALSE,
  ignore.case = TRUE,
  interpolate = TRUE
)
}
\arguments{
\item{where}{Folder in which files are located (defaults to current working
directory).}

\item{ext}{File extension to be searched for, without the "." (defaults to
\code{txt}). You can also use a character vector to specify multiple file
extensions.}

\item{lim}{A vector with two numbers determining the wavelength limits to be
considered (defaults to \code{c(300, 700)}).}

\item{decimal}{Character to be used to identify decimal plates
(defaults to \code{.}).}

\item{sep}{Column delimiting characters to be considered in addition to the
default (which are: tab, space, and ";")}

\item{subdir}{Should subdirectories within the \code{where} folder be included in
the search? (defaults to \code{FALSE}).}

\item{subdir.names}{Should subdirectory path be included in the name of the
spectra? (defaults to \code{FALSE}).}

\item{ignore.case}{Should the extension search be case insensitive? (defaults
to \code{TRUE})}

\item{interpolate}{Boolean indicated whether spectral data should be
interpolated and pruned at every nanometre. Note that this option can only
work if all input data samples the same wavelengths. Defaults to \code{TRUE}.}
}
\value{
A data.frame, containing the wavelengths in the first column and
individual imported spectral files in the subsequent columns.
}
\description{
Finds and imports reflectance/transmittance/absorbance data from spectra
files in a given location.
}
\details{
You can customise the type of parallel processing used by this function with
the \code{\link[future:plan]{future::plan()}} function. This works on all operating systems, as well
as high performance computing (HPC) environment. Similarly, you can customise
the way progress is shown with the \code{\link[progressr:handlers]{progressr::handlers()}} functions
(progress bar, acoustic feedback, nothing, etc.)
}
\examples{
spcs <- lr_get_spec(system.file("testdata", package = "lightr"), ext = "jdx")
head(spcs)

}
\seealso{
\code{\link[pavo:getspec]{pavo::getspec()}}
}
