% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drender.R
\name{drender}
\alias{drender}
\title{Render Dockerized R Markdown Documents}
\usage{
drender(input = NULL, tag = NULL, build_args = NULL,
  container_name = NULL, reset = TRUE, ...)
}
\arguments{
\item{input}{Input file to render in Docker container.}

\item{tag}{Docker image name to build, sent as docker argument \code{-t}.
If not specified, it will use the same name as the input file.}

\item{build_args}{A character string specifying additional
\code{docker build} arguments. For example,
\code{--pull=true -m="1024m" --memory-swap="-1"}.}

\item{container_name}{Docker container name to run.
If not specified, we will generate and use a random name.}

\item{reset}{Should we cleanup the Docker container and
Docker image after getting the rendered result?}

\item{...}{Additional arguments passed to
\code{\link[rmarkdown]{render}}.}
}
\value{
Rendered file is written to the same directory of the input file.
A character vector with the image name and container name will be
returned. You will be able to manage them with \code{docker}
commands later if \code{reset = FALSE}.
}
\description{
Render dockerized R Markdown documents using Docker containers.
Rabix tools/workflows will be ran if there is a \code{Rabixfile}
generated by \link{lift} under the same directory.
}
\details{
Before using \code{drender()}, run \link{lift} on the document
first to generate \code{Dockerfile}.
See \code{vignette('liftr-intro')} for details about the extended
YAML front-matter metadata format and system requirements for
rendering dockerized R Markdown documents.
}
\examples{
# 1. Dockerized R Markdown document
# Docker is required to run the example,
# so make sure we can use `docker` in shell.
dir_docker = paste0(tempdir(), '/drender_docker/')
dir.create(dir_docker)
file.copy(system.file("docker.Rmd", package = "liftr"), dir_docker)
docker_input = paste0(dir_docker, "docker.Rmd")
lift(docker_input)
\dontrun{
drender(docker_input)
# view rendered document
browseURL(paste0(dir_docker, "docker.html"))}

# 2. Dockerized R Markdown document with Rabix options
# Docker and Rabix are required to run the example,
# so make sure we can use `docker` and `rabix` in shell.
dir_rabix  = paste0(tempdir(), '/drender_rabix/')
dir.create(dir_rabix)
file.copy(system.file("rabix.Rmd", package = "liftr"), dir_rabix)
rabix_input = paste0(dir_rabix, "rabix.Rmd")
lift(rabix_input)
\dontrun{
drender(rabix_input)
# view rendered document
browseURL(paste0(dir_rabix, "rabix.html"))}
}

