% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.R
\name{segmentation}
\alias{segmentation}
\title{Image segmentation by seed-based watershed algorithm}
\usage{
segmentation(maxi, dem_nl)
}
\arguments{
\item{maxi}{cimg or rasterLayer object. image with seed points (e.g. from 
\code{\link{maxima_detection}} or \code{\link{maxima_selection}})}

\item{dem_nl}{cimg or rasterLayer object. image for seed propagation 
(typically initial image used for maxima detection).}
}
\value{
A cimg object or rasterlayer object with segments id
}
\description{
performs a seed-based watershed segmentation (wrapper for imager::watershed)
}
\examples{
data(chm_chablais3)

# median filter
chm_chablais3 <- dem_filtering(chm_chablais3,
  nl_filter = "Median", nl_size = 3,
  sigmap = 0
)$non_linear_image

# maxima detection
maxi <- maxima_detection(chm_chablais3)

# maxima selection
selected_maxi <- maxima_selection(maxi, chm_chablais3, dm = 1, dprop = 0.1)

# segmentation
seg_maxi <- segmentation(maxi, chm_chablais3)
seg_selected_maxi <- segmentation(selected_maxi, chm_chablais3)

# plot original image
raster::plot(chm_chablais3, main = "Median filter")

# plot segmented image
# replace segment with id 0 (not a tree) with NA
seg_maxi[seg_maxi == 0] <- NA
raster::plot(seg_maxi \%\% 8, main = "Segments, no maxima selection", 
col = rainbow(8))
seg_selected_maxi [seg_selected_maxi == 0] <- NA
raster::plot(seg_selected_maxi \%\% 8, main = "Segments, maxima selection", 
col = rainbow(8))
}
\seealso{
\code{\link{maxima_detection}}, \code{\link{maxima_selection}}, 
\code{\link{seg_adjust}}
}
