% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_match.R
\name{hist_detection}
\alias{hist_detection}
\title{Histogram of detection}
\usage{
hist_detection(lr, ld, matched, plot = TRUE)
}
\arguments{
\item{lr}{data.frame or matrix. 3D coordinates (X Y Height) of reference positions}

\item{ld}{data.frame or matrix. 3D coordinates (X Y Height) of detected positions}

\item{matched}{data.frame. contains pair indices, typically returned by \code{\link{tree_matching}}}

\item{plot}{boolean. should the histogram be displayed or not}
}
\value{
A list with three numerics: numbers of true detections, omissions and false detections
}
\description{
Displays the histogram of tree heights of three categories: true detections, omissions, and false detections.
}
\examples{
# create reference and detected trees
ref_trees <- cbind(c(1, 4, 3, 4, 2), c(1, 1, 2, 3, 4), c(15, 18, 20, 10, 11))
def_trees <- cbind(c(2, 2, 4, 4), c(1, 3, 4, 1), c(16, 19, 9, 15))
#
# tree matching with different buffer size
match1 <- tree_matching(ref_trees, def_trees)
match2 <- tree_matching(ref_trees, def_trees, delta_ground = 2, h_prec = 0)
#
# corresponding number of detections
hist_detection(ref_trees, def_trees, match1)
hist_detection(ref_trees, def_trees, match2)
}
\seealso{
\code{\link{tree_matching}}
}
