% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-trk.R
\name{Roussel2020}
\alias{Roussel2020}
\title{Sensor tracking algorithm}
\usage{
Roussel2020(interval = 0.5, pmin = 50)
}
\arguments{
\item{interval}{numeric. Interval used to bin the gps times and group the pulses to compute
a position at a given timepoint t.}

\item{pmin}{integer. Minimum number of pulses needed to estimate a sensor position.
For a given interval, the sensor position is not computed if the number of pulses is lower than
\code{pmin}.}
}
\description{
This function is made to be used in \link{track_sensor}. It implements an algorithm from Roussel et
al. 2020 (see reference) for sensor tracking using multiple returns to estimate the positioning of
the sensor by computing the intersection in space of the lines passing through the first and last
returns.
}
\details{
When multiple returns from a single pulse are detected, the sensor computes their positions as being
in the center of the footprint and thus all aligned. Because of that behavior, a line
drawn between and beyond those returns must cross the sensor. Thus, several consecutive pulses
emitted in a tight interval (e.g. 0.5 seconds) can be used to approximate an intersection
point in the sky that corresponds to the sensor position given that the sensor carrier hasn't
moved much during this interval. A weighted least squares method gives an approximation of the
intersection by minimizing the squared sum of the distances between the intersection point and all
the lines.
}
\examples{
# A valid file properly populated
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las = readLAS(LASfile)

# pmin = 15 because it is an extremely tiny file
# strongly decimated to reduce its size. There are
# actually few multiple returns
flightlines <- track_sensor(las, Roussel2020(pmin = 15))

plot(las@header)
plot(flightlines, add = TRUE)
}
\references{
Roussel Jean-Romain, Bourdon Jean-Francois, Achim Alexis, (2020) Range-based intensity
normalization of ALS data over forested areas using a sensor tracking method from multiple returns
(preprint) Retrieved from eartharxiv.org/k32qw
}
