% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_raster.r
\name{rOverlay}
\alias{rOverlay}
\alias{rMergeList}
\alias{rBuildVRT}
\title{RasterLayer tools}
\usage{
rOverlay(las, res, start = c(0, 0), buffer = 0)

rMergeList(raster_list)

rBuildVRT(file_list, vrt)
}
\arguments{
\item{las}{An object of class \code{LAS}}

\item{res}{numeric. resolution of the raster}

\item{start}{vector of x and y coordinates for the reference raster. Default is (0,0) meaning that
the grid aligns on (0,0).}

\item{buffer}{numeric. Extend the bounding box of the LAS object to generate a RasterLayer larger
than the point cloud}

\item{raster_list}{list. List of \code{Raster*} objects}

\item{file_list}{list. List of path to \code{Raster*} file}

\item{vrt}{charcter. Name of the VRT that must be written}
}
\description{
Internal function: a set of tools related to \code{Raster*}
\itemize{
\item \code{rOverlay}: Generates an (empty) \code{RasterLayer} that encompasse a point cloud
\item \code{rMergeList}: Merge a list of \code{Raster*} in a single \code{Raster*} preserving the
layer names
\item \code{rBuildVRT}: Create a Virtual Raster Mosaic from a set of Raster file on disk.
}
}
\keyword{internal}
