% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.r
\name{tree_detection}
\alias{tree_detection}
\title{Tree top detection based on local maxima filters}
\usage{
tree_detection(x, ws, hmin = 2)
}
\arguments{
\item{x}{A object of class \code{LAS} or an object representing a canopy height model
such as a \code{RasterLayer} or a \code{lasmetrics} or a \code{matrix}.}

\item{ws}{numeric. Size of the moving window used to the detect the local maxima. On
a raster-like object this size is in pixels and should be an odd number larger than 3.
On a raw point cloud this size is in the point cloud units (usually meters).}

\item{hmin}{numeric. Minimum height of a tree. Threshold below which a pixel or a point
cannot be a local maxima. Default 2.}
}
\value{
A \code{data.table} with the coordinates of the tree tops (X, Y, Z) if the input
is a point cloud, or a RasterLayer if the input is a raster-like object.
}
\description{
Tree top detection based on local maxima filters. There are two types of filter. The
first, called for gridded objects, works on images with a matrix-based algorithm
and the second one, called for point clouds, works at the point cloud level without any
rasterization.
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las = readLAS(LASfile, select = "xyz", filter = "-drop_z_below 0")

# point-cloud-based method

ttops = tree_detection(las, 5)

plot(las)
with(ttops, rgl::points3d(X, Y, Z, col = "red", size = 5, add = TRUE))

# raster-based method

chm = grid_canopy(las, 1, subcircle = 0.15)
chm = as.raster(chm)
kernel = matrix(1,3,3)
chm = raster::focal(chm, w = kernel, fun = median, na.rm = TRUE)

ttops = tree_detection(chm, 5)

raster::plot(chm, col = height.colors(30))
raster::plot(ttops, add = TRUE, col = "black", legend = FALSE)
}
