% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libstable4u-pkg.r
\docType{package}
\name{libstable4u-package}
\alias{libstable4u}
\alias{libstable4u-package}
\title{libstable4u: Fast and accurate evaluation, random number generation
and parameter estimation of skew stable distributions.}
\description{
libstable4u provides functions to work with skew stable distributions
in a fast and accurate way [1]. It performs:
}
\details{
\itemize{
\item Fast and accurate evaluation of the probability density function (PDF) and cumulative density function (CDF).
\item Fast and accurate evaluation of the quantile function (CDF^{-1}).
\item Random numbers generation [2].
\item Skew stable parameter estimation with:
\itemize{
\item McCulloch's method of quantiles [3].
\item Koutrouvellis' method based on the characteristic function [4].
\item Maximum likelihood estimation.
\item Modified maximum likelihood estimation as described in [1].
*The evaluation of the PDF and CDF is based on the formulas provided by John P Nolan in [5].
}
}
}
\examples{
# Set alpha, beta, sigma and mu stable parameters in a vector
pars <- c(1.5, 0.9, 1, 0)

# Generate an abscissas axis and probabilities vector
x <- seq(-5, 10, 0.05)
p <- seq(0.01, 0.99, 0.01)

# Calculate pdf, cdf and quantiles
pdf <- stable_pdf(x, pars)
cdf <- stable_cdf(x, pars)
xq  <- stable_q(p, pars)

# Generate random values
set.seed(1)
rnd <- stable_rnd(100, pars)
head(rnd)

# Estimate the parameters of the skew stable distribution given
# the generated sample:

# Using the McCulloch's estimator:
pars_init <- stable_fit_init(rnd)

# Using the Koutrouvelis' estimator, with McCulloch estimation
# as a starting point:
pars_est_K <- stable_fit_koutrouvelis(rnd, pars_init)

# Using maximum likelihood estimator:
pars_est_ML <- stable_fit_mle(rnd, pars_est_K)

# Using modified maximum likelihood estimator (see [1]):
pars_est_ML2 <- stable_fit_mle2d(rnd, pars_est_K)
}
\references{
\itemize{
\item [1] Royuela-del-Val J, Simmross-Wattenberg F, Alberola López C (2017). libstable: Fast, Parallel and High-Precision Computation of alpha-stable Distributions in R, C/C++ and MATLAB. Journal of Statistical Software, 78(1), 1-25. doi:10.18637/jss.v078.i01
\item [2] Chambers JM, Mallows CL, Stuck BW (1976). A Method for Simulating Stable Random Variables. Journal of the American Statistical Association, 71(354), 340-344. doi:10.1080/01621459.1976.10480344
\item [3] McCulloch JH (1986). Simple Consistent Estimators of Stable Distribution Parameters. Communications in Statistics - Simulation and Computation, 15(4), 1109-1136. doi:10.1080/03610918608812563
\item [4] Koutrouvelis IA (1981). An Iterative Procedure for the Estimation of the Parameters of Stable Laws. Communications in Statistics - Simulation and Computation, 10(1), 17-28. doi:10.1080/03610918108812189
\item [5] Nolan JP (1997). Numerical Calculation of Stable Densities and Distribution Functions. Stochastic Models, 13(4), 759-774. doi:10.1080/15326349708807450
}
}
\author{
Javier Royuela del Val, Federico Simmross Wattenberg and Carlos Alberola López;\cr\cr
Maintainer: Javier Royuela del Val \href{mailto:jroyval@lpi.tel.uva.es}{jroyval@lpi.tel.uva.es}
}
\keyword{package}
