/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_OTHERMETHOD_PPE_H
#define _SO_OTHERMETHOD_PPE_H

#include <so/Matrix.h>
#include <so/Table.h>

/** \struct so_OtherMethod_PPE
	 \brief A structure representing an SO/SOBlock/Estimation/PrecisionPopulationEstimates/OtherMethod element
*/
typedef struct so_OtherMethod_PPE so_OtherMethod_PPE;

/** \memberof so_OtherMethod_PPE
 * Create a new empty so_OtherMethod_PPE structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_OtherMethod_PPE_copy, so_OtherMethod_PPE_free
 */
so_OtherMethod_PPE *so_OtherMethod_PPE_new();
/** \memberof so_OtherMethod_PPE
 * Create a copy of a so_OtherMethod_PPE structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_OtherMethod_PPE_new
 */
so_OtherMethod_PPE *so_OtherMethod_PPE_copy(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Free all memory associated with a so_OtherMethod_PPE structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_OtherMethod_PPE_new
 */
void so_OtherMethod_PPE_free(so_OtherMethod_PPE *self);
void so_OtherMethod_PPE_ref(so_OtherMethod_PPE *self);
void so_OtherMethod_PPE_unref(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Get the CovarianceMatrix element
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the structure representing the CovarianceMatrix element
 * \sa so_OtherMethod_PPE_set_CovarianceMatrix
 */
so_Matrix *so_OtherMethod_PPE_get_CovarianceMatrix(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Get the CorrelationMatrix element
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the structure representing the CorrelationMatrix element
 * \sa so_OtherMethod_PPE_set_CorrelationMatrix
 */
so_Matrix *so_OtherMethod_PPE_get_CorrelationMatrix(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Get the StandardDeviation element
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the structure representing the StandardDeviation element
 * \sa so_OtherMethod_PPE_set_StandardDeviation
 */
so_Table *so_OtherMethod_PPE_get_StandardDeviation(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Get the StandardError element
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the structure representing the StandardError element
 * \sa so_OtherMethod_PPE_set_StandardError
 */
so_Table *so_OtherMethod_PPE_get_StandardError(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Get the AsymptoticCI element
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the structure representing the AsymptoticCI element
 * \sa so_OtherMethod_PPE_set_AsymptoticCI
 */
so_Table *so_OtherMethod_PPE_get_AsymptoticCI(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Get the PercentilesCI element
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the structure representing the PercentilesCI element
 * \sa so_OtherMethod_PPE_set_PercentilesCI
 */
so_Table *so_OtherMethod_PPE_get_PercentilesCI(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Set the CovarianceMatrix element
 * \param self - pointer to a so_OtherMethod_PPE
 * \param value - A pointer to a \a so_Matrix to set.
 * \sa so_OtherMethod_PPE_get_CovarianceMatrix
 */
void so_OtherMethod_PPE_set_CovarianceMatrix(so_OtherMethod_PPE *self, so_Matrix *value);
/** \memberof so_OtherMethod_PPE
 * Set the CorrelationMatrix element
 * \param self - pointer to a so_OtherMethod_PPE
 * \param value - A pointer to a \a so_Matrix to set.
 * \sa so_OtherMethod_PPE_get_CorrelationMatrix
 */
void so_OtherMethod_PPE_set_CorrelationMatrix(so_OtherMethod_PPE *self, so_Matrix *value);
/** \memberof so_OtherMethod_PPE
 * Set the StandardDeviation element
 * \param self - pointer to a so_OtherMethod_PPE
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_OtherMethod_PPE_get_StandardDeviation
 */
void so_OtherMethod_PPE_set_StandardDeviation(so_OtherMethod_PPE *self, so_Table *value);
/** \memberof so_OtherMethod_PPE
 * Set the StandardError element
 * \param self - pointer to a so_OtherMethod_PPE
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_OtherMethod_PPE_get_StandardError
 */
void so_OtherMethod_PPE_set_StandardError(so_OtherMethod_PPE *self, so_Table *value);
/** \memberof so_OtherMethod_PPE
 * Set the AsymptoticCI element
 * \param self - pointer to a so_OtherMethod_PPE
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_OtherMethod_PPE_get_AsymptoticCI
 */
void so_OtherMethod_PPE_set_AsymptoticCI(so_OtherMethod_PPE *self, so_Table *value);
/** \memberof so_OtherMethod_PPE
 * Set the PercentilesCI element
 * \param self - pointer to a so_OtherMethod_PPE
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_OtherMethod_PPE_get_PercentilesCI
 */
void so_OtherMethod_PPE_set_PercentilesCI(so_OtherMethod_PPE *self, so_Table *value);
/** \memberof so_OtherMethod_PPE
 * Create a new CovarianceMatrix element and insert it into the so_OtherMethod_PPE
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Matrix *so_OtherMethod_PPE_create_CovarianceMatrix(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Create a new CorrelationMatrix element and insert it into the so_OtherMethod_PPE
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Matrix *so_OtherMethod_PPE_create_CorrelationMatrix(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Create a new StandardDeviation element and insert it into the so_OtherMethod_PPE
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_OtherMethod_PPE_create_StandardDeviation(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Create a new StandardError element and insert it into the so_OtherMethod_PPE
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_OtherMethod_PPE_create_StandardError(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Create a new AsymptoticCI element and insert it into the so_OtherMethod_PPE
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_OtherMethod_PPE_create_AsymptoticCI(so_OtherMethod_PPE *self);
/** \memberof so_OtherMethod_PPE
 * Create a new PercentilesCI element and insert it into the so_OtherMethod_PPE
 * \param self - pointer to a so_OtherMethod_PPE
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_OtherMethod_PPE_create_PercentilesCI(so_OtherMethod_PPE *self);

#endif
