/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/OFMeasures.h>
#include <so/private/OFMeasures.h>

so_OFMeasures *so_OFMeasures_new()
{
	so_OFMeasures *object = calloc(sizeof(so_OFMeasures), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_OFMeasures *so_OFMeasures_copy(so_OFMeasures *self)
{
	so_OFMeasures *dest = so_OFMeasures_new();
	if (dest) {
		if (self->Likelihood) {
			dest->Likelihood_number = self->Likelihood_number;
			dest->Likelihood = &(dest->Likelihood_number);
		}
		if (self->LogLikelihood) {
			dest->LogLikelihood_number = self->LogLikelihood_number;
			dest->LogLikelihood = &(dest->LogLikelihood_number);
		}
		if (self->Deviance) {
			dest->Deviance_number = self->Deviance_number;
			dest->Deviance = &(dest->Deviance_number);
		}
		if (self->ToolObjFunction) {
			dest->ToolObjFunction_number = self->ToolObjFunction_number;
			dest->ToolObjFunction = &(dest->ToolObjFunction_number);
		}
		if (self->IndividualContribtoLL) {
			dest->IndividualContribtoLL = so_Table_copy(self->IndividualContribtoLL);
			if (!dest->IndividualContribtoLL) {
				so_OFMeasures_free(dest);
				return NULL;
			}
		}
		if (self->InformationCriteria) {
			dest->InformationCriteria = so_InformationCriteria_copy(self->InformationCriteria);
			if (!dest->InformationCriteria) {
				so_OFMeasures_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_OFMeasures_free(so_OFMeasures *self)
{
	if (self) {
		so_Table_unref(self->IndividualContribtoLL);
		so_InformationCriteria_unref(self->InformationCriteria);
		free(self);
	}
}

void so_OFMeasures_ref(so_OFMeasures *self)
{
	self->reference_count++;
}

void so_OFMeasures_unref(so_OFMeasures *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_OFMeasures_free(self);
		}
	}
}

double *so_OFMeasures_get_Likelihood(so_OFMeasures *self)
{
	return self->Likelihood;
}

double *so_OFMeasures_get_LogLikelihood(so_OFMeasures *self)
{
	return self->LogLikelihood;
}

double *so_OFMeasures_get_Deviance(so_OFMeasures *self)
{
	return self->Deviance;
}

double *so_OFMeasures_get_ToolObjFunction(so_OFMeasures *self)
{
	return self->ToolObjFunction;
}

so_Table *so_OFMeasures_get_IndividualContribtoLL(so_OFMeasures *self)
{
	return self->IndividualContribtoLL;
}

so_InformationCriteria *so_OFMeasures_get_InformationCriteria(so_OFMeasures *self)
{
	return self->InformationCriteria;
}

void so_OFMeasures_set_Likelihood(so_OFMeasures *self, double *value)
{
	if (value) {
		self->Likelihood_number = *value;
		self->Likelihood = &(self->Likelihood_number);
	} else {
		self->Likelihood = value;
	}
}

void so_OFMeasures_set_LogLikelihood(so_OFMeasures *self, double *value)
{
	if (value) {
		self->LogLikelihood_number = *value;
		self->LogLikelihood = &(self->LogLikelihood_number);
	} else {
		self->LogLikelihood = value;
	}
}

void so_OFMeasures_set_Deviance(so_OFMeasures *self, double *value)
{
	if (value) {
		self->Deviance_number = *value;
		self->Deviance = &(self->Deviance_number);
	} else {
		self->Deviance = value;
	}
}

void so_OFMeasures_set_ToolObjFunction(so_OFMeasures *self, double *value)
{
	if (value) {
		self->ToolObjFunction_number = *value;
		self->ToolObjFunction = &(self->ToolObjFunction_number);
	} else {
		self->ToolObjFunction = value;
	}
}

void so_OFMeasures_set_IndividualContribtoLL(so_OFMeasures *self, so_Table *value)
{
	so_Table_unref(self->IndividualContribtoLL);
	self->IndividualContribtoLL = value;
}

void so_OFMeasures_set_InformationCriteria(so_OFMeasures *self, so_InformationCriteria *value)
{
	so_InformationCriteria_unref(self->InformationCriteria);
	self->InformationCriteria = value;
}

so_Table *so_OFMeasures_create_IndividualContribtoLL(so_OFMeasures *self)
{
	so_Table *obj = so_Table_new("IndividualContribtoLL");
	if (obj) {
		self->IndividualContribtoLL = obj;
	}
	return obj;
}

so_InformationCriteria *so_OFMeasures_create_InformationCriteria(so_OFMeasures *self)
{
	so_InformationCriteria *obj = so_InformationCriteria_new();
	if (obj) {
		self->InformationCriteria = obj;
	}
	return obj;
}

int so_OFMeasures_xml(so_OFMeasures *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->Likelihood || self->LogLikelihood || self->Deviance || self->ToolObjFunction || self->IndividualContribtoLL || self->InformationCriteria) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "OFMeasures");
		if (rc < 0) return 1;
		if (self->Likelihood) {
			char *number_string = pharmml_double_to_string(self->Likelihood_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "Likelihood", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		if (self->LogLikelihood) {
			char *number_string = pharmml_double_to_string(self->LogLikelihood_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "LogLikelihood", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		if (self->Deviance) {
			char *number_string = pharmml_double_to_string(self->Deviance_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "Deviance", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		if (self->ToolObjFunction) {
			char *number_string = pharmml_double_to_string(self->ToolObjFunction_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "ToolObjFunction", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		if (self->IndividualContribtoLL) {
			rc = so_Table_xml(self->IndividualContribtoLL, writer, "IndividualContribtoLL");
			if (rc != 0) return rc;
		}
		if (self->InformationCriteria) {
			rc = so_InformationCriteria_xml(self->InformationCriteria, writer);
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_OFMeasures_start_element(so_OFMeasures *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_IndividualContribtoLL) {
		int fail = so_Table_start_element(self->IndividualContribtoLL, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_InformationCriteria) {
		int fail = so_InformationCriteria_start_element(self->InformationCriteria, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "Likelihood") == 0) {
		self->in_Likelihood = 1;
	} else if (strcmp(localname, "LogLikelihood") == 0) {
		self->in_LogLikelihood = 1;
	} else if (strcmp(localname, "Deviance") == 0) {
		self->in_Deviance = 1;
	} else if (strcmp(localname, "ToolObjFunction") == 0) {
		self->in_ToolObjFunction = 1;
	} else if (strcmp(localname, "IndividualContribtoLL") == 0) {
		so_Table *IndividualContribtoLL = so_OFMeasures_create_IndividualContribtoLL(self);
		if (!IndividualContribtoLL) {
			return 1;
		}
		self->in_IndividualContribtoLL = 1;
	} else if (strcmp(localname, "InformationCriteria") == 0) {
		so_InformationCriteria *InformationCriteria = so_OFMeasures_create_InformationCriteria(self);
		if (!InformationCriteria) {
			return 1;
		}
		self->in_InformationCriteria = 1;
	}
	return 0;
}

void so_OFMeasures_end_element(so_OFMeasures *self, const char *localname)
{
	if (strcmp(localname, "Likelihood") == 0 && self->in_Likelihood) {
		self->in_Likelihood = 0;
	} else if (strcmp(localname, "LogLikelihood") == 0 && self->in_LogLikelihood) {
		self->in_LogLikelihood = 0;
	} else if (strcmp(localname, "Deviance") == 0 && self->in_Deviance) {
		self->in_Deviance = 0;
	} else if (strcmp(localname, "ToolObjFunction") == 0 && self->in_ToolObjFunction) {
		self->in_ToolObjFunction = 0;
	} else if (strcmp(localname, "IndividualContribtoLL") == 0 && self->in_IndividualContribtoLL) {
		self->in_IndividualContribtoLL = 0;
	} else if (strcmp(localname, "InformationCriteria") == 0 && self->in_InformationCriteria) {
		self->in_InformationCriteria = 0;
	} else if (self->in_IndividualContribtoLL) {
		so_Table_end_element(self->IndividualContribtoLL, localname);
	} else if (self->in_InformationCriteria) {
		so_InformationCriteria_end_element(self->InformationCriteria, localname);
	}
}

int so_OFMeasures_characters(so_OFMeasures *self, const char *ch, int len)
{
	if (self->in_Likelihood) {
		self->Likelihood_number = pharmml_string_to_double(ch);
		self->Likelihood = &(self->Likelihood_number);
	} else if (self->in_LogLikelihood) {
		self->LogLikelihood_number = pharmml_string_to_double(ch);
		self->LogLikelihood = &(self->LogLikelihood_number);
	} else if (self->in_Deviance) {
		self->Deviance_number = pharmml_string_to_double(ch);
		self->Deviance = &(self->Deviance_number);
	} else if (self->in_ToolObjFunction) {
		self->ToolObjFunction_number = pharmml_string_to_double(ch);
		self->ToolObjFunction = &(self->ToolObjFunction_number);
	} else if (self->in_IndividualContribtoLL) {
		int fail = so_Table_characters(self->IndividualContribtoLL, ch, len);
		if (fail) return 1;
	} else if (self->in_InformationCriteria) {
		int fail = so_InformationCriteria_characters(self->InformationCriteria, ch, len);
		if (fail) return 1;
	}
	return 0;
}
