% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderDigest}
\alias{AppenderDigest}
\title{Abstract class for digests}
\description{
\strong{Abstract classes} are exported for package developers that want to extend
them, they cannot be instantiated directly.

Abstract class for Appenders that transmit digests of several log events
at once, for example \link{AppenderPushbullet}, \link{AppenderGmail} and
\link{AppenderSendmail}.
}
\section{Fields}{


\describe{
\item{\code{subject_layout}, \code{set_layout(subject_layout)}}{Like \code{layout}, but
used to format the subject/title of the digest. While \code{layout} is applied
to each LogEvent of the digest, \code{subject_layout} is only applied to
the last one.
}
}



\describe{
\item{\code{buffer_size, set_buffer_size(x)}}{\code{integer} scalar \code{>= 0} Number of
\link{LogEvents} to buffer.
}

\item{\code{buffer_events}, \code{buffer_df}, \code{buffer_dt}}{
The contents of the buffer as a \code{list} of \link[=LogEvent]{LogEvents}, a
\code{data.frame} or a \code{data.table}.
}

\item{\code{flush_threshold}, \code{set_flush_threshold()}}{\code{integer} or \code{character}
\link[=log_level]{log level}. Minimum event level that will trigger flushing of
the buffer. This behaviour is implemented through \code{should_flush()},
and you can modify that function for different behaviour.
}
\item{\code{should_flush(event)}, \code{set_should_flush(x)}}{
A function with exactly one arguments: \code{event}.
If the function returns \code{TRUE}, flushing of the buffer
is triggered. Defaults to flushing if an event of level \code{error}
or higher is registered.}
}



\describe{
\item{\code{dt}}{Get the log recorded by this \code{Appender} as a \code{data.table}
with a maximum of \code{buffer_size} rows}
}



\describe{
\item{\code{data}}{Get the log recorded by this \code{Appender} as a \code{data.frame}}
}



\describe{
\item{\code{threshold}, \code{set_threshold(level)}}{\code{character} or \code{integer} scalar.
The minimum log level that triggers this logger. See \link{log_levels}}
\item{\code{layout}, \code{set_layout(layout)}}{a \code{Layout} that will be used for
formatting the \code{LogEvents} passed to this Appender}
\item{\code{destination}}{The output destination of the \code{Appender} in
human-readable form (mainly for print output)}
}



\describe{
\item{\code{filters}, \code{set_filters(filters)}}{a \code{list} that may contain
\code{functions} or any \R object with a \code{filter()} method. These functions
must have exactly one argument: \code{event} which will get passed the
LogEvent when the Filterable's \code{filter()} method is invoked.
If all of these functions evaluate to \code{TRUE} the LogEvent is passed on.
Since LogEvents have reference semantics, filters can also be abused to
modify them before they are passed on. Look at the source code of
\code{\link[=with_log_level]{with_log_level()}} or \code{\link[=with_log_value]{with_log_value()}} for examples.
}
}
}

\section{Methods}{




\describe{
\item{\code{flush()}}{Manually trigger flushing of the buffer}
}


\describe{
\item{\code{show(n, threshold)}}{Show the last \code{n} log entries with a log level
bellow \code{threshold}. The log entries will be formatted for console output
via this Appenders \link{Layout}}
}


\describe{
\item{\code{append(event)}}{Tell the Appender to process a \link{LogEvent} \code{event}.
This method is usually not called by the user, but invoked by a
\link{Logger}
}
}


\describe{
\item{\code{filter(event)}}{Determine whether the LogEvent \code{x} should be passed
on to Appenders (\code{TRUE}) or not (\code{FALSE}). See also the active binding
\code{filters}}
\item{\code{add_filter(filter, name = NULL)}, \code{remove_filter(pos)}}{
Add or remove a filter. When adding a filter an optional \code{name} can
be specified. \code{remove_filter()} can remove by position or name (if one
was specified)
}
}
}

\seealso{
\link{LayoutFormat}, \link{LayoutGlue}

Other abstract classes: \code{\link{AppenderMail}},
  \code{\link{AppenderMemory}},
  \code{\link{AppenderTable}}, \code{\link{Filterable}}
}
\concept{abstract classes}
