% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_logger.R
\name{get_logger}
\alias{get_logger}
\alias{get_logger_glue}
\title{Get/Create a Logger}
\usage{
get_logger(name, class = Logger, reset = FALSE)

get_logger_glue(name)
}
\arguments{
\item{name}{a \code{character} scalar or vector: The qualified name of the Logger
as a hierarchical value.}

\item{class}{An \link[R6:R6]{R6ClassGenerator} object. Usually \code{Logger} or \code{LoggerGlue}
are the only valid choices.}

\item{reset}{a \code{logical} scalar. If \code{TRUE} the logger is reset to an
unconfigured state. Unlike \code{$config(NULL)} this also replaces a
\code{LoggerGlue} with vanilla \code{Logger}. Please note that this will invalidate
Logger references created before the reset call (see examples).}
}
\value{
a \link{Logger}
}
\description{
Get/Create a Logger
}
\examples{
lg <- get_logger("log/ger/test")
# equivalent to
lg <- get_logger(c("log", "ger", "test"))
lg$warn("a \%s message", "warning")
lg
lg$parent

if (requireNamespace('glue')){
  lg <- get_logger_glue("log/ger")
}
lg$warn("a {.text} message", .text = "warning")

# completely reset 'glue' to an unconfigured vanilla Logger
get_logger("log/ger", reset = TRUE)
# this invalidates references to the Logger
try(lg$info("lg has been invalidated an no longer works"))

# we have to recreate it
lg <- get_logger("log/ger")
lg$info("now all is well again")
}
