% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-lgpfit.R
\name{plot_draws}
\alias{plot_draws}
\alias{plot_beta}
\alias{plot_warp}
\alias{plot_effect_times}
\title{Visualize the distribution of parameter draws}
\usage{
plot_draws(
  fit,
  type = "intervals",
  regex_pars = c("alpha", "ell", "wrp", "sigma", "phi", "gamma"),
  ...
)

plot_beta(fit, type = "dens", verbose = TRUE, ...)

plot_warp(
  fit,
  num_points = 300,
  window_size = 48,
  color = colorset("red", "dark"),
  alpha = 0.5
)

plot_effect_times(fit, type = "areas", verbose = TRUE, ...)
}
\arguments{
\item{fit}{an object of class \linkS4class{lgpfit}}

\item{type}{plot type, allowed options are "intervals", "dens",
"areas", and "trace"}

\item{regex_pars}{regex for parameter names to plot}

\item{...}{additional arguments for the \code{bayesplot} function
\code{\link[bayesplot]{mcmc_intervals}}, \code{\link[bayesplot]{mcmc_dens}},
\code{\link[bayesplot]{mcmc_areas}} or \code{\link[bayesplot]{mcmc_trace}}}

\item{verbose}{Can any output be printed?}

\item{num_points}{number of plot points}

\item{window_size}{width of time window}

\item{color}{line color}

\item{alpha}{line alpha}
}
\value{
a \code{ggplot} object or list of them
}
\description{
Visualize the distribution of parameter draws
}
\section{Functions}{
\itemize{
\item \code{plot_draws}: visualizes the distribution of any set of
model parameters (defaults to kernel hyperparameters and possible
observation model parameters)

\item \code{plot_beta}: visualizes the distribution of the
individual-specific disease effect magnitude parameter draws

\item \code{plot_warp}: visualizes the input warping function for
different draws of the warping steepness parameter

\item \code{plot_effect_times}: visualizes the input warping function for
different parameter draws
}}

\seealso{
Other main plot functions: 
\code{\link{plot_components}()},
\code{\link{plot_pred}()}
}
\concept{main plot functions}
