% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/adaptiveSchemes.R
\name{andrieuthomsh}
\alias{andrieuthomsh}
\title{andrieuthomsh function}
\usage{
andrieuthomsh(inith, alpha, C, targetacceptance = 0.574)
}
\arguments{
\item{inith}{initial h}

\item{alpha}{parameter \eqn{\alpha}{\alpha}}

\item{C}{parameter \eqn{C}{C}}

\item{targetacceptance}{target acceptance probability}
}
\value{
an object of class andrieuthomsh
}
\description{
A Robbins-Munro stochastic approximation update is used to adapt the tuning parameter of the proposal kernel.
The idea is to update the tuning parameter at each iteration of the sampler:
\deqn{h^{(i+1)} = h^{(i)} + \eta^{(i+1)}(\alpha^{(i)} - \alpha_{opt}),}{h^{(i+1)} = h^{(i)} + \eta^{(i+1)}(\alpha^{(i)} - \alpha_{opt}),}
where \eqn{h^{(i)}}{h^{(i)}} and \eqn{\alpha^{(i)}}{\alpha^{(i)}} are the tuning parameter and acceptance probability at iteration
\eqn{i}{i} and \eqn{\alpha_{opt}}{\alpha_{opt}} is a target acceptance probability. For Gaussian targets, and in the limit
as the dimension of the problem tends to infinity, an appropriate target acceptance probability for
MALA algorithms is 0.574. The sequence \eqn{\{\eta^{(i)}\}}{\{\eta^{(i)}\}} is chosen so that
\eqn{\sum_{i=0}^\infty\eta^{(i)}}{\sum_{i=0}^\infty\eta^{(i)}} is infinite whilst \eqn{\sum_{i=0}^\infty\left(\eta^{(i)}\right)^{1+\epsilon}}{\sum_{i=0}^\infty\left(\eta^{(i)}\right)^{1+\epsilon}} is
finite for \eqn{\epsilon>0}{\epsilon>0}. These two conditions ensure that any value of \eqn{h}{h} can be reached, but in a way that
maintains the ergodic behaviour of the chain. One class of sequences with this property is,
\deqn{\eta^{(i)} = \frac{C}{i^\alpha},}{\eta^{(i)} = \frac{C}{i^\alpha},}
where \eqn{\alpha\in(0,1]}{\alpha\in(0,1]} and \eqn{C>0}{C>0}.The scheme is set via
the \code{mcmcpars} function.
}
\examples{
andrieuthomsh(inith=1,alpha=0.5,C=1,targetacceptance=0.574)
}
\references{
\enumerate{
    \item Andrieu C, Thoms J (2008). A tutorial on adaptive MCMC. Statistics and Computing, 18(4), 343-373.
    \item Robbins H, Munro S (1951). A Stochastic Approximation Methods. The Annals of Mathematical Statistics, 22(3), 400-407.
    \item Roberts G, Rosenthal J (2001). Optimal Scaling for Various Metropolis-Hastings Algorithms. Statistical Science, 16(4), 351-367.
}
}
\seealso{
\link{mcmcpars}, \link{lgcpPredict}
}

