% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsets.R
\name{plot.fsets}
\alias{plot.fsets}
\title{Plot membership degrees stored in the instance of the S3 class
\code{\link[=fsets]{fsets()}} as a line diagram.}
\usage{
\method{plot}{fsets}(x, ...)
}
\arguments{
\item{x}{An instance of class \code{\link[=fsets]{fsets()}}}

\item{...}{Other arguments that are passed to the underlying \code{\link[=ts.plot]{ts.plot()}}
function.}
}
\value{
Result of the \code{\link[=ts.plot]{ts.plot()}} method.
}
\description{
This function plots the membership degrees stored in the instance of the
\code{\link[=fsets]{fsets()}} class. Internally, the membership degrees are
transformed into a time-series object and viewed in a plot using the
\code{\link[=ts.plot]{ts.plot()}} function. This function is useful mainly to see the
shape of fuzzy sets on regularly sampled inputs.
}
\examples{
d <- lcut(0:1000/1000, name='x')
plot(d)

# Additional arguments are passed to the ts.plot method
# Here thick lines represent atomic linguistic expressions,
# i.e. ``small'', ``medium'', and ``big''.
plot(d,
     ylab='membership degree',
     xlab='values',
     gpars=list(lwd=c(rep(1, 3), 5, rep(1, 5), 5, rep(1, 7), 5, rep(1,4))))
}
\seealso{
\code{\link[=fsets]{fsets()}}, \code{\link[=fcut]{fcut()}}, \code{\link[=lcut]{lcut()}}, \code{\link[=ts.plot]{ts.plot()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{multivariate}
\keyword{robust}
