% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/antecedents.R
\name{antecedents}
\alias{antecedents}
\title{Extract antecedent-part (left-hand side) of rules in a list}
\usage{
antecedents(rules)
}
\arguments{
\item{rules}{Either a list of character vectors or an object of class \code{\link[=farules]{farules()}}.}
}
\value{
A list of character vectors.
}
\description{
Given a list of rules or an instance of the S3 \code{\link[=farules]{farules()}} class,
the function returns a list of their antecedents (i.e.
left-hand side of rules).
}
\details{
This function assumes \code{rules} to be a valid \code{\link[=farules]{farules()}} object or
a list of character vectors where
the first element of each vector is a consequent part and the
rest is an antecedent part of rules. Function returns a list of
antecedents.
}
\examples{
    rules <- list(c('a', 'b', 'c'), c('d'), c('a', 'e'))
    antecedents(rules)
}
\seealso{
\code{\link[=consequents]{consequents()}}, \code{\link[=farules]{farules()}}, \code{\link[=searchrules]{searchrules()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
