% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.frbe.R
\name{print.frbe}
\alias{print.frbe}
\title{Print an instance of the \code{\link[=frbe]{frbe()}} class}
\usage{
\method{print}{frbe}(x, ...)
}
\arguments{
\item{x}{An instance of \code{\link[=frbe]{frbe()}} class}

\item{...}{Unused.}
}
\value{
None.
}
\description{
Format an object of the \code{\link[=frbe]{frbe()}} class into human readable form
and print it to the output.
}
\details{
Format an object of the \code{\link[=frbe]{frbe()}} class into human readable form
and print it to the output.
}
\examples{

  # prepare data (from the forecast package)
  library(forecast)
  horizon <- 10
  train <- wineind[-1 * (length(wineind)-horizon+1):length(wineind)]
  test <- wineind[(length(wineind)-horizon+1):length(wineind)]
  f <- frbe(ts(train, frequency=frequency(wineind)), h=horizon)
  print(f)
  print(test)

}
\references{
Štěpnička, M., Burda, M., Štěpničková, L. Fuzzy Rule Base
Ensemble Generated from Data by Linguistic Associations Mining. FUZZY SET
SYST. 2015.
}
\seealso{
\code{\link[=frbe]{frbe()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
