% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/str_spine_case.R
\name{str_spine_case}
\alias{str_hyphen_case}
\alias{str_spinal_case}
\alias{str_spine_case}
\title{str_spine_case}
\usage{
str_spine_case(string, whitespace = getOption("lettercase.whitespace",
  "[\\\\s-_]"), collapse.whitespace = getOption("collapse.whitespace", TRUE))

str_spinal_case(string, whitespace = getOption("lettercase.whitespace",
  "[\\\\s-_]"), collapse.whitespace = getOption("collapse.whitespace", TRUE))

str_hyphen_case(string, whitespace = getOption("lettercase.whitespace",
  "[\\\\s-_]"), collapse.whitespace = getOption("collapse.whitespace", TRUE))
}
\arguments{
\item{string}{object to turn into a title case}

\item{whitespace}{character; regular expression pattern for matching whitespace
characters}

\item{collapse.whitespace}{logical; whether adjacent whitespace is collapsed


* characters are all lower case
* non- \code{\\w}, \code{\\s} and - are dropped
* \code{\\w} and - are converted to underscore
* no support for acronyms}
}
\description{
Function used to convert character vectors to spine case format.
}
\examples{
str_spine_case( "One Flew Over The Cuckoo's Nest" ) # One Flew Over The Cuckoo's Nest
  str_spine_case( "Catch 22" )  # catch-22
  str_spine_case( "Catch_ 22" )
}

