% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/str_is.R
\name{str_is}
\alias{make_str_are}
\alias{make_str_is}
\alias{str_are_upper_case}
\alias{str_are_uppercase}
\alias{str_is}
\alias{str_is_all}
\title{Test whether strings are of the specified type}
\usage{
str_is(string, type, autostart = 30L)

str_is_all(...)

make_str_is(type)

make_str_are(type)

str_are_uppercase(string)

str_are_upper_case(string)

str_are_uppercase(string)

str_are_upper_case(string)
}
\arguments{
\item{string}{vector. This must be an atomic vector, and will be coerced to
a character vector}

\item{type}{function that transforms the string to type}

\item{autostart}{integer; number of elements to test before concluding that
  \code{string} is of the suggested \code{type}. (Default: 30)}

\item{...}{arguments passed to subsequent functions}
}
\value{
For \code{str_is} a logical vector indicating which entries of \code{string}
are of the specified \code{type},

For \code{str_is_all} and \code{str_are} a logical vector of length one
indicating whether all of \code{string} is of the specified type(s)

For \code{make_str_is} and \code{make_str_are} functions that return
functions that accept a single argument and return whether the string is of
the specified types.
}
\description{
Family of functions for testing whether strings are of the specified type.
}
\details{
\code{str_is} determines if the string belongs to one of the supported
 lettercase types. Comparisons are made by comparing the original string
 to a transformed version of the string. If the two are identical, then
 the functions are equivalent.

 \code{autostart} determines the maximum number of values

 \code{make_str_is} and \code{make_string_are} are metafunctions that return
 functions that test for the given lettercase types.
}
\examples{
string = c( "catch-22", "finnegans wake" )
  str_is( string, str_lower_case )

  str_transform( string, str_capitalize, str_delete_nonword )
  str_delete_nonword( str_capitalize( string ) )      # SAME

  # magrittr:
  \dontrun{
    string \%>\% str_capitalize \%>\% str_delete_nonword   # SAME
  }
}
\seealso{
\code{\link{str_transform}} \cr
  \code{\link{make_str_replace}} \cr
  \code{\link{make_str_delete}} \cr
}

