## ---- include=FALSE---------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=4.5, fig.height=4)

## ----include=FALSE----------------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))

## ----read-------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ----labels-----------------------------------------------------------------------------------------------------------
l <- rd("Employee_lbl")

## ----sp, fig.width=4.5------------------------------------------------------------------------------------------------
Plot(Years, Salary)

## ----spEnhance, fig.width=4.5-----------------------------------------------------------------------------------------
Plot(Years, Salary, enhance=TRUE)

## ----sploess, fig.width=4.5-------------------------------------------------------------------------------------------
Plot(Years, Salary, fit="loess", plot_errors=TRUE)

## ----exp, fig.width=4.5-----------------------------------------------------------------------------------------------
Plot(Years, Salary, fit="exp", plot_errors=TRUE)

## ----size, fig.width=4.5----------------------------------------------------------------------------------------------
Plot(Years, Salary, size=Pre)

## ----three, fig.width=5, fig.height=4---------------------------------------------------------------------------------
Plot(c(Pre, Post), Salary, fit="lm", fit_se=0)

## ----spmat, fig.width=5, fig.height=5---------------------------------------------------------------------------------
Plot(c(Salary, Years, Pre, Post), fit=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
x <- rnorm(4000)
y <- rnorm(4000)
Plot(x, y)

## ---------------------------------------------------------------------------------------------------------------------
Plot(x, y, smooth=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
Plot(x, y, trans=0.95)

## ---- fig.height=2.75-------------------------------------------------------------------------------------------------
Plot(Salary)

## ---- fig.height=2.75-------------------------------------------------------------------------------------------------
Plot(Salary, vbs_plot="b")

## ---- fig.height=5.5, fig.width=5.5-----------------------------------------------------------------------------------
Plot(Salary, row_names)

## ---- fig.height=5.75, fig.width=5.5----------------------------------------------------------------------------------
Plot(Salary, row_names, sort_yx="0", segments_y=FALSE)

## ---- fig.height=5.75, fig.width=6.0----------------------------------------------------------------------------------
Plot(c(Pre, Post), row_names)

## ----by, fig.width=6--------------------------------------------------------------------------------------------------
Plot(Years, Salary, by=Gender)

## ----byordered, fig.width=6-------------------------------------------------------------------------------------------
d$Gender.f <- factor(d$Gender, ordered=TRUE)
Plot(Years, Salary, by=Gender.f)

## ----bycolors, fig.width=6--------------------------------------------------------------------------------------------
Plot(Years, Salary, by=Gender, size=2, fit="lm",
     fill=c("olivedrab3", "gold1"), 
     color=c("darkgreen", "gold4")
)

## ---- fig.width=4.5, fig.height=4-------------------------------------------------------------------------------------
Plot(Years, Salary, by1=Gender, fit="lm")

## ---------------------------------------------------------------------------------------------------------------------
Plot(Salary, Dept)

## ---- figwidth=6, fig.height=2.75-------------------------------------------------------------------------------------
Plot(Salary, by=Dept)

## ---- figwidth=6, fig.height=4----------------------------------------------------------------------------------------
Plot(Salary, by1=Dept)

## ---- fig.height=4----------------------------------------------------------------------------------------------------
Plot(Salary, by1=Dept, vbs_plot="vs")

## ---- figwidth=6------------------------------------------------------------------------------------------------------
BoxPlot(Salary, by1=Gender, vbs_mean=TRUE, box_fill="lightgoldenrod")

## ---- figwidth=6------------------------------------------------------------------------------------------------------
Plot(Salary, Dept, by=Gender)

## ---- fig.width=6, fig.height=4---------------------------------------------------------------------------------------
Plot(Years, Salary, by1=Dept, by2=Gender, by=Plan, fit="lm")

## ---- fig.width=6, fig.height=7---------------------------------------------------------------------------------------
Plot(Salary, by1=Gender, by2=Dept)

## ---- fig.width=6, fig.height=4---------------------------------------------------------------------------------------
Plot(Salary, by1=Dept, by=Gender)

## ---- fig.height=3----------------------------------------------------------------------------------------------------
Plot(Dept, Gender)

## ---- fig.height=4, fig.width=6---------------------------------------------------------------------------------------
Plot(Dept, Gender, radius=.6, power=0.8, pad_x=0.05, pad_y=0.05)

## ---- fig.height=3----------------------------------------------------------------------------------------------------
Plot(Dept, by1=Gender)

## ---- fig.height=2.5--------------------------------------------------------------------------------------------------
Plot(Dept)

