# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Input requirement
#' @param X transaction matrix
#' @param d final demand vector
#' @examples
#' set.seed(200100)
#' X <- matrix(rnorm(100), nrow = 10)
#' d <- rnorm(10)
#' input_requirement(X,d)
#' @export
input_requirement <- function(X, d) {
    .Call('_leontief_input_requirement', PACKAGE = 'leontief', X, d)
}

#' Augmented input requirement
#' @param X transaction matrix
#' @param w wage vector
#' @param c household consumption vector
#' @param d final demand vector
#' @examples
#' set.seed(200100)
#' X <- matrix(rnorm(100), nrow = 10)
#' w <- rnorm(10)
#' c <- rnorm(10)
#' d <- rnorm(10)
#' augmented_input_requirement(X,w,c,d)
#' @export
augmented_input_requirement <- function(X, w, c, d) {
    .Call('_leontief_augmented_input_requirement', PACKAGE = 'leontief', X, w, c, d)
}

#' Output allocation
#' @param X transaction matrix
#' @param d final demand vector
#' @examples
#' set.seed(200100)
#' X <- matrix(rnorm(100), nrow = 10)
#' d <- rnorm(10)
#' output_allocation(X,d)
#' @export
output_allocation <- function(X, d) {
    .Call('_leontief_output_allocation', PACKAGE = 'leontief', X, d)
}

#' Leontief inverse
#' @param A input requirement matrix
#' @examples
#' set.seed(200100)
#' A <- matrix(rnorm(100), nrow = 10)
#' leontief_inverse(A)
#' @export
leontief_inverse <- function(A) {
    .Call('_leontief_leontief_inverse', PACKAGE = 'leontief', A)
}

#' Equilibrium output
#' @param L Leontief inverse matrix
#' @param d final demand vector
#' @examples
#' set.seed(200100)
#' L <- matrix(rnorm(100), nrow = 10)
#' d <- rnorm(10)
#' equilibrium_output(L,d)
#' @export
equilibrium_output <- function(L, d) {
    .Call('_leontief_equilibrium_output', PACKAGE = 'leontief', L, d)
}

#' Output multiplier
#' @param L Leontief inverse matrix
#' @examples
#' set.seed(200100)
#' L <- matrix(rnorm(100), nrow = 10)
#' output_multiplier(L)
#' @export
output_multiplier <- function(L) {
    .Call('_leontief_output_multiplier', PACKAGE = 'leontief', L)
}

#' Income multiplier
#' @param L Leontief inverse matrix
#' @param w wage vector
#' @export
income_multiplier <- function(L, w) {
    .Call('_leontief_income_multiplier', PACKAGE = 'leontief', L, w)
}

#' Employment multiplier
#' @param L Leontief inverse matrix
#' @param e employment coefficients vector
#' @export
employment_multiplier <- function(L, e) {
    .Call('_leontief_employment_multiplier', PACKAGE = 'leontief', L, e)
}

#' Employment number
#' @param L Leontief inverse matrix
#' @param e employment coefficients vector
#' @param c change in final demand
#' @export
employment_number <- function(L, e, c) {
    .Call('_leontief_employment_number', PACKAGE = 'leontief', L, e, c)
}

#' Backward linkage
#' @param A input requirement matrix
#' @export
backward_linkage <- function(A) {
    .Call('_leontief_backward_linkage', PACKAGE = 'leontief', A)
}

#' Forward linkage
#' @param A input requirement matrix
#' @export
forward_linkage <- function(A) {
    .Call('_leontief_forward_linkage', PACKAGE = 'leontief', A)
}

#' Power of dispersion
#' @param L Leontief inverse matrix
#' @export
power_dispersion <- function(L) {
    .Call('_leontief_power_dispersion', PACKAGE = 'leontief', L)
}

#' Power of dispersion coefficient of variation
#' @param L Leontief inverse matrix
#' @export
power_dispersion_cv <- function(L) {
    .Call('_leontief_power_dispersion_cv', PACKAGE = 'leontief', L)
}

#' Sensitivity of dispersion coefficient of variation
#' @param L Leontief inverse matrix
#' @export
sensitivity_dispersion <- function(L) {
    .Call('_leontief_sensitivity_dispersion', PACKAGE = 'leontief', L)
}

#' Sensititivy of dispersion coefficient of variation
#' @param L Leontief inverse matrix
#' @export
sensitivity_dispersion_cv <- function(L) {
    .Call('_leontief_sensitivity_dispersion_cv', PACKAGE = 'leontief', L)
}

#' Multiplier product matrix
#' @param L Leontief inverse matrix
#' @export
multiplier_product_matrix <- function(L) {
    .Call('_leontief_multiplier_product_matrix', PACKAGE = 'leontief', L)
}

