% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primitive-spacer.R
\name{primitive_spacer}
\alias{primitive_spacer}
\title{Guide primitive: spacer}
\usage{
primitive_spacer(
  space = NULL,
  title = waiver(),
  theme = NULL,
  position = waiver()
)
}
\arguments{
\item{space}{A [\verb{<unit[1]>}][grid::unit()]}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \verb{<PrimitiveSpacer>} primitive guide that can be used inside
other guides.
}
\description{
This function constructs a spacer \link[=guide-primitives]{guide primitive}.
}
\section{Styling options}{
#' Below are the \link[ggplot2:theme]{theme} options that determine the styling of
this guide. This guide does not have option dependent on its role as axis or
legend.
\itemize{
\item \code{legendry.guide.spacing} A \code{\link[grid:unit]{<unit>}} setting the amount of
spacing when the \code{space} argument is \code{NULL}.
}
}

\examples{
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  guides(
    x = guide_axis_stack("axis", primitive_spacer(unit(1, "cm")), "axis")
  )
}
\seealso{
Other primitives: 
\code{\link{primitive_box}()},
\code{\link{primitive_bracket}()},
\code{\link{primitive_fence}()},
\code{\link{primitive_labels}()},
\code{\link{primitive_line}()},
\code{\link{primitive_segments}()},
\code{\link{primitive_ticks}()},
\code{\link{primitive_title}()}
}
\concept{primitives}
