% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanag.R
\name{create_lM}
\alias{create_lM}
\title{Create lefkoMat Object from Given Input Matrices or an MPM Database}
\usage{
create_lM(
  mats,
  stageframe = NULL,
  hstages = NA,
  agestages = NA,
  historical = FALSE,
  agebystage = FALSE,
  UFdecomp = TRUE,
  entrystage = 1,
  poporder = 1,
  patchorder = 1,
  yearorder = NA,
  matrix_id = NULL,
  add_FC = TRUE
)
}
\arguments{
\item{mats}{A list of A matrices, or, if importing from a matrix database
such as COMPADRE or COMADRE, then the object holding the database.}

\item{stageframe}{A stageframe describing all stages utilized.}

\item{hstages}{A data frame outlining the order of historical stages, if
matrices provided in \code{mats} are historical. Defaults to NA.}

\item{agestages}{A data frame outlining the order of ahistorical age-stages,
if age-by-stage matrices are provided.}

\item{historical}{A logical value indicating whether input matrices are
historical or not. Defaults to FALSE.}

\item{agebystage}{A logical value indicating whether input matrices are
ahistorical age-by-stage matrices. If TRUE, then object \code{agestages} is
required. Defaults to FALSE.}

\item{UFdecomp}{A logical value indicating whether U and F matrices should be
inferred. Defaults to TRUE.}

\item{entrystage}{The stage or stages produced by reproductive individuals.
Used to determine which transitions are reproductive for U-F decomposition.
Defaults to \code{1}, which corresponds to the first stage in the stageframe.}

\item{poporder}{The order of populations in the list supplied in object
\code{mats}. Defaults to 1.}

\item{patchorder}{The order of patches in the list supplied in object
\code{mats}. Defaults to 1.}

\item{yearorder}{The order of monitoring occasions in the list supplied in
object \code{mats}. Defaults to NA, which leads to each matrix within each
population-patch combination being a different monitoring occasion.}

\item{matrix_id}{The values of \code{MatrixID} from the used database
corresponding to the matrices to import, if importing from a database. Not
used if importing a list of matrices.}

\item{add_FC}{A logical value indicating whether to sum the \code{matF} and
\code{matC} matrices to produce the \code{F} matrix. If \code{FALSE}, then
only uses the \code{matF} matrix. Only used if importing from the COMPADRE or
COMADRE database. Defaults to \code{TRUE}.}
}
\value{
A \code{lefkoMat} object incorporating the matrices input in object
\code{mats} as object \code{A}, their U and F decompositions in objects
\code{U} and \code{F} (if requested), the provided stageframe as object
\code{ahstages}, the order of historical stages as object \code{hstages} (if
\code{historical = TRUE}), the order of matrices as object \code{labels}, and
a short quality control section used by the \code{\link{summary.lefkoMat}()}
function.
}
\description{
Function \code{create_lM()} creates lefkoMat objects from supplied matrices
and extra information, or from a supplied MPM database such as COMPADRE or
COMADRE.
}
\section{Notes for importing lists of matrices}{

U and F decomposition assumes that elements holding fecundity values are
to be interpreted solely as fecundity rates. Users wishing to split these
elements between fecundity and survival should do so manually after running
this function.

Age-by-stage MPMs require an \code{agestages} data frame outlining the order
of age-stages. This data frame has 3 variables: \code{stage_id}, which is the
number of the stage as labelled by the equivalently named variable in the
\code{stageframe}; \code{stage}, which is the official name of the stage as
given in the equivalently named variable in the \code{stageframe}; and
\code{age}, which of course gives the age associated with the stage at that
time. The number of rows must be equal to the number of rows and columns of
each entered matrix.
}

\section{Notes for importing from COMPADRE or COMADRE}{

For this function to operate, users must have either the COMPADRE database
or the COMADRE database loaded into the global environment. Note that the
sample databases supplied within package \code{Rcompadre} will not work with
this function.

This function does not and cannot replace the wonderful tools offered to
explore the COMPADRE and COMADRE packages. Please see package
\code{Rcompadre} to use those tools. Note that function \code{import_Com()}
has no relationship to the \code{Rcompadre} development team.

Function \code{import_Com()} requires that the dimensions of all matrices
imported into a single \code{lefkoMat} object be equal.

The reproductive and maturity status of each stage is determined by patterns
assessed within the \code{F} matrices. Users should check that these values
make sense.

Stage names may be edited manually afterward.
}

\examples{
# These matrices are of 9 populations of the plant species Anthyllis
# vulneraria, and were originally published in Davison et al. (2010) Journal
# of Ecology 98:255-267 (doi: 10.1111/j.1365-2745.2009.01611.x).

sizevector <- c(1, 1, 2, 3) # These sizes are not from the original paper
stagevector <- c("Sdl", "Veg", "SmFlo", "LFlo")
repvector <- c(0, 0, 1, 1)
obsvector <- c(1, 1, 1, 1)
matvector <- c(0, 1, 1, 1)
immvector <- c(1, 0, 0, 0)
propvector <- c(0, 0, 0, 0)
indataset <- c(1, 1, 1, 1)
binvec <- c(0.5, 0.5, 0.5, 0.5)

anthframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

# POPN C 2003-2004
XC3 <- matrix(c(0, 0, 1.74, 1.74,
0.208333333, 0, 0, 0.057142857,
0.041666667, 0.076923077, 0, 0,
0.083333333, 0.076923077, 0.066666667, 0.028571429), 4, 4, byrow = TRUE)

# 2004-2005
XC4 <- matrix(c(0, 0, 0.3, 0.6,
0.32183908, 0.142857143, 0, 0,
0.16091954, 0.285714286, 0, 0,
0.252873563, 0.285714286, 0.5, 0.6), 4, 4, byrow = TRUE)

# 2005-2006
XC5 <- matrix(c(0, 0, 0.50625, 0.675,
0, 0, 0, 0.035714286,
0.1, 0.068965517, 0.0625, 0.107142857,
0.3, 0.137931034, 0, 0.071428571), 4, 4, byrow = TRUE)

# POPN E 2003-2004
XE3 <- matrix(c(0, 0, 2.44, 6.569230769,
0.196428571, 0, 0, 0,
0.125, 0.5, 0, 0,
0.160714286, 0.5, 0.133333333, 0.076923077), 4, 4, byrow = TRUE)

XE4 <- matrix(c(0, 0, 0.45, 0.646153846,
0.06557377, 0.090909091, 0.125, 0,
0.032786885, 0, 0.125, 0.076923077,
0.049180328, 0, 0.125, 0.230769231), 4, 4, byrow = TRUE)

XE5 <- matrix(c(0, 0, 2.85, 3.99,
0.083333333, 0, 0, 0,
0, 0, 0, 0,
0.416666667, 0.1, 0, 0.1), 4, 4, byrow = TRUE)

mats_list <- list(XC3, XC4, XC5, XE3, XE4, XE5)
yr_ord <- c(1, 2, 3, 1, 2, 3)
pch_ord <- c(1, 1, 1, 2, 2, 2)

anth_lefkoMat <- create_lM(mats_list, anthframe, hstages = NA,
  historical = FALSE, poporder = 1, patchorder = pch_ord, yearorder = yr_ord)

# A theoretical example showcasing historical matrices
sizevector <- c(1, 2, 3) # These sizes are not from the original paper
stagevector <- c("Sdl", "Veg", "Flo")
repvector <- c(0, 0, 1)
obsvector <- c(1, 1, 1)
matvector <- c(0, 1, 1)
immvector <- c(1, 0, 0)
propvector <- c(1, 0, 0)
indataset <- c(1, 1, 1)
binvec <- c(0.5, 0.5, 0.5)

exframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

A1 <- matrix(c(0.10, 0, 0, 0.12, 0, 0, 0.15, 0, 0,
  0.15, 0, 0, 0.17, 0, 0, 0.20, 0, 0,
  0.20, 0, 0, 0.22, 0, 0, 0.25, 0, 0,
  0, 0.20, 0, 0, 0.22, 0, 0, 0.25, 0,
  0, 0.25, 0, 0, 0.27, 0, 0, 0.30, 0,
  0, 0.30, 0, 0, 0.32, 0, 0, 0.35, 0,
  0, 0, 2.00, 0, 0, 3.00, 0, 0, 4.00,
  0, 0, 0.35, 0, 0, 0.37, 0, 0, 0.40,
  0, 0, 0.40, 0, 0, 0.42, 0, 0, 0.45), 9, 9, byrow = TRUE)

A2 <- matrix(c(0.10, 0, 0, 0.12, 0, 0, 0.15, 0, 0,
  0.15, 0, 0, 0.17, 0, 0, 0.20, 0, 0,
  0.20, 0, 0, 0.22, 0, 0, 0.25, 0, 0,
  0, 0.20, 0, 0, 0.22, 0, 0, 0.25, 0,
  0, 0.25, 0, 0, 0.27, 0, 0, 0.30, 0,
  0, 0.30, 0, 0, 0.32, 0, 0, 0.35, 0,
  0, 0, 5.00, 0, 0, 6.00, 0, 0, 7.00,
  0, 0, 0.35, 0, 0, 0.37, 0, 0, 0.40,
  0, 0, 0.40, 0, 0, 0.42, 0, 0, 0.45), 9, 9, byrow = TRUE)

A3 <- matrix(c(0.10, 0, 0, 0.12, 0, 0, 0.15, 0, 0,
  0.15, 0, 0, 0.17, 0, 0, 0.20, 0, 0,
  0.20, 0, 0, 0.22, 0, 0, 0.25, 0, 0,
  0, 0.20, 0, 0, 0.22, 0, 0, 0.25, 0,
  0, 0.25, 0, 0, 0.27, 0, 0, 0.30, 0,
  0, 0.30, 0, 0, 0.32, 0, 0, 0.35, 0,
  0, 0, 8.00, 0, 0, 9.00, 0, 0, 10.00,
  0, 0, 0.35, 0, 0, 0.37, 0, 0, 0.40,
  0, 0, 0.40, 0, 0, 0.42, 0, 0, 0.45), 9, 9, byrow = TRUE)

B1 <- matrix(c(0.10, 0, 0, 0.12, 0, 0, 0.15, 0, 0,
  0.15, 0, 0, 0.17, 0, 0, 0.20, 0, 0,
  0.20, 0, 0, 0.22, 0, 0, 0.25, 0, 0,
  0, 0.20, 0, 0, 0.22, 0, 0, 0.25, 0,
  0, 0.25, 0, 0, 0.27, 0, 0, 0.30, 0,
  0, 0.30, 0, 0, 0.32, 0, 0, 0.35, 0,
  0, 0, 11.00, 0, 0, 12.00, 0, 0, 13.00,
  0, 0, 0.35, 0, 0, 0.37, 0, 0, 0.40,
  0, 0, 0.40, 0, 0, 0.42, 0, 0, 0.45), 9, 9, byrow = TRUE)

B2 <- matrix(c(0.10, 0, 0, 0.12, 0, 0, 0.15, 0, 0,
  0.15, 0, 0, 0.17, 0, 0, 0.20, 0, 0,
  0.20, 0, 0, 0.22, 0, 0, 0.25, 0, 0,
  0, 0.20, 0, 0, 0.22, 0, 0, 0.25, 0,
  0, 0.25, 0, 0, 0.27, 0, 0, 0.30, 0,
  0, 0.30, 0, 0, 0.32, 0, 0, 0.35, 0,
  0, 0, 14.00, 0, 0, 15.00, 0, 0, 16.00,
  0, 0, 0.35, 0, 0, 0.37, 0, 0, 0.40,
  0, 0, 0.40, 0, 0, 0.42, 0, 0, 0.45), 9, 9, byrow = TRUE)

B3 <- matrix(c(0.10, 0, 0, 0.12, 0, 0, 0.15, 0, 0,
  0.15, 0, 0, 0.17, 0, 0, 0.20, 0, 0,
  0.20, 0, 0, 0.22, 0, 0, 0.25, 0, 0,
  0, 0.20, 0, 0, 0.22, 0, 0, 0.25, 0,
  0, 0.25, 0, 0, 0.27, 0, 0, 0.30, 0,
  0, 0.30, 0, 0, 0.32, 0, 0, 0.35, 0,
  0, 0, 17.00, 0, 0, 18.00, 0, 0, 19.00,
  0, 0, 0.35, 0, 0, 0.37, 0, 0, 0.40,
  0, 0, 0.40, 0, 0, 0.42, 0, 0, 0.45), 9, 9, byrow = TRUE)

histmats <- list(A1, A2, A3, B1, B2, B3)
stageframe <- exframe
pch_ord <- c("A", "A", "A", "B", "B", "B")
yr_ord <- c(1, 2, 3, 1, 2, 3)

hist_trial <- create_lM(histmats, exframe, historical = TRUE,
  UFdecomp = TRUE, entrystage = 1, patchorder = pch_ord, yearorder = yr_ord)
  
}
\seealso{
\code{\link{add_lM}()}

\code{\link{delete_lM}()}

\code{\link{subset_lM}()}
}
