% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popchar.R
\name{sf_distrib}
\alias{sf_distrib}
\title{Test for overdispersion and zero inflation in size and fecundity}
\usage{
sf_distrib(data, size = NA, fec = NA, repst = NA)
}
\arguments{
\item{data}{A historical vertical data file, which is a data frame of class
\code{hfvdata}.}

\item{size}{The name or column number of the variable corresponding to size.}

\item{fec}{The name or column number of the variable corresponding to
fecundity. The name of the variable should correspond to the proper time,
either time *t* or time *t*-1.}

\item{repst}{The name or column number of the variable corresponding to
reproductive status in time *t*. Required if fecundity distribution will be
tested.}
}
\value{
Produces text describing the degree and significance of
overdispersion and zero inflation. The tests are chi-squared score tests
based on the expectations of mean = variance, and 0s as abundant as predicted
by the value of lambda estimated from the dataset. See van der Broek (1995)
for more details.
}
\description{
Function \code{sf_distrib} takes a historically formatted vertical data as
input and tests whether size and fecundity data are dispersed according to a
Poisson distribution (where mean = variance), and whether the number of 0s
exceeds expectations.
}
\examples{
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr",
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r",
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframeln, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

sf_distrib(lathvertln, fec = "feca2", repst = "repstatus2")

}
