% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{repvalue3.lefkoMat}
\alias{repvalue3.lefkoMat}
\title{Estimate Reproductive Value for a lefkoMat Object}
\usage{
\method{repvalue3}{lefkoMat}(mats)
}
\arguments{
\item{mats}{An object of class \code{lefkoMat} object.}
}
\value{
This function returns the reproductive values for stages of a
population projection matrix. The nature of the output depends on whether the
lefkoMat object used as input is ahistorical or historical. In both cases,
raw reproductive values are estimated as the left eigenvector associated with
the largest real part of the dominant eigenvalue estimated via the \code{\link[RSpectra]{eigs}()}
function in package 'RSpectra', divided either by the first non-zero element
of the left eigenvector.

If an ahistorical matrix set is used as input, then the output is a data
frame that includes the number of the matrix within the `$A` element of the 
input \code{lefkoMat} object, followed by the original stage id, the new
stage id (numeric and assigned through \code{\link{sf_create}())}, the original 
given size, and the reproductive value estimate within a variable called
\code{repvalue}. 

If a historical matrix set is used as input, then a list with two elements is
output. The first element is a data frame showing the reproductive values
given in terms of across-year stage pairs, as estimated in the procedure
described above. The second element is another data frame showing the
reproductive values of the basic stages in the associated stageframe. The 
reproductive values in this second data frame are estimated via the approach
developed in Ehrlen (2000), in which each ahistorical stage's reproductive 
value is the average of the RVs summed by stage at time \emph{t} weighted by 
the proportion of that stage pair within the historical stable stage 
distribution associated with the matrix.
}
\description{
\code{repvalue3.lefkoMat()} returns the reproductive values for stages in a
set of population projection matrices. This function can handle large and 
sparse matrices, and so can be used with large historical matrices, IPMs, 
age x stage matrices, as well as smaller ahistorical matrices.
}
\examples{
\donttest{
data(lathyrus)
sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector, repstatus = repvector, 
                       obsstatus = obsvector, matstatus = matvector, immstatus = immvector, 
                       indataset = indataset, binhalfwidth = binvec, propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988, patchidcol = "SUBPLOT", 
                         individcol = "GENET", blocksize = 9, juvcol = "Seedling1988", 
                         size1col = "Volume88", repstr1col = "FCODE88", 
                         fec1col = "Intactseed88", dead1col = "Dead1988", 
                         nonobs1col = "Dormant1988", stageassign = lathframe, 
                         stagesize = "sizea", censorcol = "Missing1988", 
                         censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathover3 <- overwrite(stage3 = c("Sd", "Sd", "Sdl"), stage2 = c("Sd", "Sd", "Sd"), 
                       stage1 = c("Sd", "rep", "rep"), givenrate = c(0.345, 0.054))

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = c(1989, 1990), 
                   stages = c("stage3", "stage2", "stage1"), repmatrix = lathrepm, 
                   overwrite = lathover3, yearcol = "year2", 
                   indivcol = "individ", reduce = TRUE)

ehrlen3mean <- lmean(ehrlen3)
repvalue3(ehrlen3mean)
}

}
\seealso{
\code{\link{repvalue3}()}

\code{\link{repvalue3.matrix}()}
}
