% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_lcp.R
\name{validate_lcp}
\alias{validate_lcp}
\title{validate_lcp}
\usage{
validate_lcp(lcp, comparison, buffers = c(50, 100, 250, 500, 1000))
}
\arguments{
\item{lcp}{Least Cost Path to assess the accuracy of. Expects object of class SpatialLines/SpatialLinesDataFrame}

\item{comparison}{\code{SpatialLines} or \code{SpatialLinesDataFrame} to validate the Least Cost Path against.}

\item{buffers}{\code{numeric vector} of buffer distances to assess. Default values are c(50, 100, 250, 500, 1000).}
}
\value{
data.frame object

\code{data.frame} (base package). The resultant object identifies the percentage of the lcp within x distance (as supplied in the buffers argument) from the provided comparison object.
}
\description{
Calculates accuracy of Least Cost Path
}
\details{
Calculates the accuracy of the Least Cost Path using the buffer method proposed by Goodchild and Hunter (1997).
}
\examples{
x1 <- c(1,5,4,8)
y1 <- c(1,3,4,7)
line1 <- sp::SpatialLines(list(sp::Lines(sp::Line(cbind(x1,y1)), ID='a')))
x2 <- c(1,5,5,8)
y2 <- c(1,4,6,7)
line2 <- sp::SpatialLines(list(sp::Lines(sp::Line(cbind(x2,y2)), ID='b')))

val_lcp <- validate_lcp(lcp = line1, comparison = line2, buffers = c(0.1, 0.2, 0.5, 1))
}
\author{
Joseph Lewis
}
