% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/playback.R
\name{addPlayback}
\alias{addPlayback}
\title{Add Playback to Leaflet}
\usage{
addPlayback(
  map,
  data,
  time = "time",
  icon = NULL,
  pathOpts = pathOptions(),
  options = playbackOptions()
)
}
\arguments{
\item{map}{a map widget}

\item{data}{data must be a POINT Simple Feature or a list of POINT Simple
Feature's with a time column. It can also be a JSON string which must be in
a specific form. See the Details for further information.}

\item{time}{The column name of the time column. Default is \code{"time"}.}

\item{icon}{an icon which can be created with \code{\link[leaflet]{makeIcon}}}

\item{pathOpts}{style the CircleMarkers with
\code{\link[leaflet]{pathOptions}}}

\item{options}{List of additional options. See \code{\link{playbackOptions}}}
}
\value{
the new \code{map} object
}
\description{
The \href{https://github.com/hallahan/LeafletPlayback}{LeafletPlayback plugin}
provides the ability to replay GPS Points in the form of
POINT Simple Features. Rather than simply animating a marker along a
polyline, the speed of the animation is synchronized to a clock. The playback
functionality is similar to a video player; you can start and stop playback or
change the playback speed.
}
\details{
If data is a JSON string, it must have the following form:
\preformatted{
{
  "type": "Feature",
  "geometry": {
    "type": "MultiPoint",
    "coordinates": [
      [-123.2653968, 44.54962188],
      [-123.26542599, 44.54951009]
    ]
},
  "properties": {
    "time": [1366067072000, 1366067074000]
  }
}
}
}
\note{
If used in Shiny, you can listen to 2 events
\itemize{
 \item `map-ID`+"_pb_mouseover"
 \item `map-ID`+"_pb_click"
}
}
\examples{
\dontrun{
library(leaflet)
library(leaflet.extras2)
library(sf)

## Single Elements
data <- sf::st_as_sf(leaflet::atlStorms2005[1,])
data <- st_cast(data, "POINT")
data$time = as.POSIXct(
  seq.POSIXt(Sys.time() - 1000, Sys.time(), length.out = nrow(data)))

leaflet() \%>\%
  addTiles() \%>\%
  addPlayback(data = data,
              options = playbackOptions(radius = 3),
              pathOpts = pathOptions(weight = 5))


## Multiple Elements
data <- sf::st_as_sf(leaflet::atlStorms2005[1:5,])
data$Name <- as.character(data$Name)
data <- st_cast(data, "POINT")
data <- split(data, f = data$Name)
lapply(1:length(data), function(x) {
  data[[x]]$time <<- as.POSIXct(
    seq.POSIXt(Sys.time() - 1000, Sys.time(), length.out = nrow(data[[x]])))
})

leaflet() \%>\%
  addTiles() \%>\%
  addPlayback(data = data,
              options = playbackOptions(radius = 3,
                                        color = c("red","green","blue",
                                                  "orange","yellow")),
              pathOpts = pathOptions(weight = 5))
}
}
\references{
\url{https://github.com/hallahan/LeafletPlayback}
}
\seealso{
Other Playback Functions: 
\code{\link{playbackOptions}()},
\code{\link{removePlayback}()}
}
\concept{Playback Functions}
