% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{get.options.lbfgs}
\alias{get.options.lbfgs}
\title{Get Options for L-BFGS Optimization}
\usage{
get.options.lbfgs(
  maxIterations = 100,
  factor = 1e+07,
  projectedGradientTol = 0,
  maxCorrections = 5
)
}
\arguments{
\item{maxIterations}{A positive integer representing the maximum number of iterations.}

\item{factor}{A number that determines the condition for stopping the iterations. Use, for example, 1e12 for low accuracy, 1e7 (default) for moderate accuracy, and 1e1 for extremely high accuracy. The default is 1e7.}

\item{projectedGradientTol}{A number used to stop the iteration using the projected gradient. The default is zero.}

\item{maxCorrections}{The maximum number of variable metric corrections allowed in the limited memory matrix. The default is 5.}
}
\value{
A list with the given options.
}
\description{
Use this function to get optimization options in \link{estim.varma} or \link{search.varma} functions.
}
