% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/halting_tests.R
\name{ks_halt}
\alias{ks_halt}
\title{A univariate halting test using the Kolmogorov-Smirnov Test, which must be satisfied for all condition pairs.}
\usage{
ks_halt(condition, covariates, thresh)
}
\arguments{
\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A columnwise matrix containing
covariates to match the conditions on.}

\item{thresh}{The return value of halting_test has to be greater than
or equal to thresh for the matched groups.}
}
\value{
The ratio of the p-value and the threshold, or 0 if the p-value is
        less than the threshold. If there are more than two conditions,
        it returns the smallest value found for any condition pair.
}
\description{
The condition must have two levels.
}
\details{
Note that unlike many tests, the null hypothesis is that the two samples are
are drawn from the same distribution.

Warnings such as "cannot compute exact p-value with ties" are suppressed.
}
