% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.lcc}
\alias{predict.lcc}
\title{Predictions from an \code{lcc} Object}
\usage{
\method{predict}{lcc}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{lcc},
representing a fitted longitudinal concordance correlation
function.}

\item{...}{further arguments passed to \code{\link{predict.lme}}.}
}
\description{
The predict method for a class \code{lcc}.
}
\details{
See methods for \code{\link{nlme}} objects to get more
  details.
}
\examples{

\dontrun{
fm1<-lcc(dataset = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
predict(fm1)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{fitted.lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@usp.br}
}
