% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aml_score_data.R
\name{aml_score_data}
\alias{aml_score_data}
\title{Function to score new data and predict change for each single currency pair}
\usage{
aml_score_data(symbol, timeframe, path_model, path_data, path_sbxm, path_sbxs)
}
\arguments{
\item{symbol}{Character symbol of the asset for which the model shall predict}

\item{timeframe}{Data timeframe e.g. 60 min}

\item{path_model}{Path where the models are be stored}

\item{path_data}{Path where the aggregated historical data is stored, if exists in rds format}

\item{path_sbxm}{Path to the sandbox where file with predicted price should be written (master terminal)}

\item{path_sbxs}{Path to the sandbox where file with predicted price should be written (slave terminal)}
}
\value{
Function is writing file into Decision Support System folder, mainly file with price change prediction in pips
}
\description{
Function is using the latest data from the financial assets indicator pattern and deep learning model.
Prediction is a price change in the future for that asset will be used by the trading system

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
Performs fresh data reading from the rds file
}
\examples{

\donttest{

# test of function aml_make_model is duplicated here
library(dplyr)
library(readr)
library(lubridate)
library(h2o)
library(magrittr)
library(lazytrade)

path_model <- normalizePath(tempdir(),winslash = "/")
path_data <- normalizePath(tempdir(),winslash = "/")

ind = system.file("extdata", "AI_RSIADXUSDJPY60.csv",
                  package = "lazytrade") \%>\% read_csv(col_names = FALSE)

ind$X1 <- ymd_hms(ind$X1)

write_csv(ind, file.path(path_data, "AI_RSIADXUSDJPY60.csv"), col_names = FALSE)


# data transformation using the custom function for one symbol
aml_collect_data(indicator_dataset = ind,
                 symbol = 'USDJPY',
                 timeframe = 60,
                 path_data = path_data)
# start h2o engine (using all CPU's by default)

h2o.init(nthreads = 2)


# performing Deep Learning Regression using the custom function
aml_make_model(symbol = 'USDJPY',
               timeframe = 60,
               path_model = path_model,
               path_data = path_data,
               force_update=FALSE,
               num_nn_options = 2)


path_sbxm <- normalizePath(tempdir(),winslash = "/")
path_sbxs <- normalizePath(tempdir(),winslash = "/")


# score the latest data to generate predictions for one currency pair
aml_score_data(symbol = 'USDJPY',
               timeframe = 60,
               path_model = path_model,
               path_data = path_data,
               path_sbxm = path_sbxm,
               path_sbxs = path_sbxs)

# stop h2o engine
h2o.shutdown(prompt = FALSE)

#set delay to insure h2o unit closes properly before the next test
Sys.sleep(5)

}



}
\author{
(C) 2020 Vladimir Zhbanko
}
