% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_profit_factor.R
\name{util_profit_factor}
\alias{util_profit_factor}
\title{Calculate Profit Factor}
\usage{
util_profit_factor(x)
}
\arguments{
\item{x}{column vector with profit or loss of the orders for one system}
}
\value{
function should calculate profit factor for this vector and return one value also as vector
}
\description{
Calculate profit factor using a data vector with the trading results
}
\examples{

library(magrittr)
library(dplyr)
library(lazytrade)
data(profit_factor_data)
profit_factor_data \%>\%
   group_by(X1) \%>\%
   summarise(PnL = sum(X5),
             NumTrades = n(),
             PrFact = util_profit_factor(X5)) \%>\%
   select(PrFact) \%>\% head(1) \%>\% as.vector() \%>\% round(3)


}
\author{
(C) 2019 Vladimir Zhbanko
}
