% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_market_type.R
\name{evaluate_market_type}
\alias{evaluate_market_type}
\title{Function to score data and predict current market type using pre-trained classification model}
\usage{
evaluate_market_type(x, path_model, num_cols)
}
\arguments{
\item{x}{- dataframe with one column containing asset indicator in the time descending order,
typically 64 or more values}

\item{path_model}{- path to the model}

\item{num_cols}{- number of columns (features) in the final vector input to the model}
}
\value{
dataframe with predicted value of the market type
}
\description{
PURPOSE: Function that uses Deep Learning model and Time Series Column of the dataframe
           to find out specific market type of the financial asset
           it will also discard bad result outputting -1 if it is the case
}
\details{
it is mandatory to switch on the virtual h2o machine with h2o.init()
also to shut it down with h2o.shutdown(prompt = F)
}
\examples{

\donttest{

library(h2o)
library(magrittr)
library(dplyr)
library(readr)
library(lazytrade)

path_model <- normalizePath(tempdir(),winslash = "/")
path_data <- normalizePath(tempdir(),winslash = "/")

data(macd_ML2)

# start h2o engine (using all CPU's by default)
h2o.init()

# performing Deep Learning Regression using the custom function
# this function stores model to the temp location
mt_make_model(indicator_dataset = macd_ML2,
              num_bars = 64,
              path_model = path_model,
              path_data = path_data)


# Use sample data
data(macd_100)

# use one column for testing
x <- macd_100[ ,2]


evaluate_market_type(x = x,
                     path_model = path_model,
                     num_cols = 64)

h2o.shutdown(prompt = FALSE)

#set delay to insure h2o unit closes properly before the next test
Sys.sleep(5)

}

}
