% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aml_test_model.R
\name{aml_test_model}
\alias{aml_test_model}
\title{Function to test the model and conditionally decide to update existing model for a single currency pair}
\usage{
aml_test_model(
  symbol,
  num_bars,
  timeframe,
  path_model,
  path_data,
  path_sbxm = path_sbxm,
  path_sbxs = path_sbxs
)
}
\arguments{
\item{symbol}{Character symbol of the asset for which to train the model}

\item{num_bars}{Number of bars used to test the model}

\item{timeframe}{Data timeframe e.g. 60 min}

\item{path_model}{Path where the models are be stored}

\item{path_data}{Path where the aggregated historical data is stored, if exists in rds format}

\item{path_sbxm}{Path to the sandbox where file with strategy test results should be written (master terminal)}

\item{path_sbxs}{Path to the sandbox where file with strategy test results should be written (slave terminal)}
}
\value{
Function is writing file into Decision Support System folder
}
\description{
Function is designed to test the trading decision generated by the Deep learning regression model.
It is doing so by simulating trading strategy outcome.
The outcome of this function will be also used to define best trigger to join into the
tradin opportunity
}
\details{
Function is reading price data and corresponding indicator.
Starting from the trained model function will test the trading strategy using simplified trading approach.
Trading approach will entail using the last available indicator data, predict the price change for every row,
trade will be simulating by holding the asset for 3, 5, 10 and 34 hours.
Several trigger points will be evaluated selecting the most optimal trading trigger.
Function is writing most optimal decision into *.csv file
Such file will be used by the function aml_make_model.R to decide whether model must be updated...
}
\examples{

\donttest{

library(dplyr)
library(magrittr)
library(readr)
library(h2o)
library(lazytrade)
library(lubridate)

path_model <- normalizePath(tempdir(),winslash = "/")
path_data <- normalizePath(tempdir(),winslash = "/")

ind = system.file("extdata", "AI_RSIADXUSDJPY60.csv",
                  package = "lazytrade") \%>\% read_csv(col_names = FALSE)

ind$X1 <- ymd_hms(ind$X1)

write_csv(ind, file.path(path_data, "AI_RSIADXUSDJPY60.csv"), col_names = FALSE)

# data transformation using the custom function for one symbol
aml_collect_data(indicator_dataset = ind,
                 symbol = 'USDJPY',
                 timeframe = 60,
                 path_data = path_data)


# start h2o engine (using all CPU's by default)
h2o.init()


# performing Deep Learning Regression using the custom function
aml_make_model(symbol = 'USDJPY',
               timeframe = 60,
               path_model = path_model,
               path_data = path_data,
               force_update=FALSE)

path_sbxm <- normalizePath(tempdir(),winslash = "/")
path_sbxs <- normalizePath(tempdir(),winslash = "/")

# score the latest data to generate predictions for one currency pair
aml_score_data(symbol = 'USDJPY',
               timeframe = 60,
               path_model = path_model,
               path_data = path_data,
               path_sbxm = path_sbxm,
               path_sbxs = path_sbxs)

# test the results of predictions
aml_test_model(symbol = 'USDJPY',
               num_bars = 600,
               timeframe = 60,
               path_model = path_model,
               path_data = path_data,
               path_sbxm = path_sbxm,
               path_sbxs = path_sbxs)

# stop h2o engine
h2o.shutdown(prompt = FALSE)

#set delay to insure h2o unit closes properly before the next test
Sys.sleep(5)

}



}
\author{
(C) 2020 Vladimir Zhbanko
}
